/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingModel;

class DebuggingBasicProverEnvironment<T>
implements BasicProverEnvironment<T> {
    private final BasicProverEnvironment<T> delegate;
    private final DebuggingAssertions debugging;

    DebuggingBasicProverEnvironment(BasicProverEnvironment<T> pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (BasicProverEnvironment)Preconditions.checkNotNull(pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public void pop() {
        this.debugging.assertThreadLocal();
        this.delegate.pop();
    }

    @Override
    public @Nullable T addConstraint(BooleanFormula constraint) throws InterruptedException {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(constraint);
        return this.delegate.addConstraint(constraint);
    }

    @Override
    public void push() throws InterruptedException {
        this.debugging.assertThreadLocal();
        this.delegate.push();
    }

    @Override
    public int size() {
        this.debugging.assertThreadLocal();
        return this.delegate.size();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        this.debugging.assertThreadLocal();
        return this.delegate.isUnsat();
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        this.debugging.assertThreadLocal();
        for (BooleanFormula f : assumptions) {
            this.debugging.assertFormulaInContext(f);
        }
        return this.delegate.isUnsatWithAssumptions(assumptions);
    }

    @Override
    public Model getModel() throws SolverException {
        this.debugging.assertThreadLocal();
        return new DebuggingModel(this.delegate.getModel(), this.debugging);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        this.debugging.assertThreadLocal();
        return this.delegate.getUnsatCore();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        this.debugging.assertThreadLocal();
        for (BooleanFormula f : assumptions) {
            this.debugging.assertFormulaInContext(f);
        }
        return this.delegate.unsatCoreOverAssumptions(assumptions);
    }

    @Override
    public void close() {
        this.debugging.assertThreadLocal();
        this.delegate.close();
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        this.debugging.assertThreadLocal();
        for (BooleanFormula f : important) {
            this.debugging.assertFormulaInContext(f);
        }
        return this.delegate.allSat(callback, important);
    }
}

