/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.microsoft.z3.Native;
import com.microsoft.z3.Status;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.PropagatorBackend;
import org.sosy_lab.java_smt.api.UserPropagator;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaManager;

final class Z3UserPropagator
extends Native.UserPropagatorBase
implements PropagatorBackend {
    private final Z3FormulaCreator creator;
    private final Z3FormulaManager manager;
    private final UserPropagator userPropagator;
    private final long z3True;
    private final long z3False;
    private final Map<Long, BooleanFormula> canonicalizer = new HashMap<Long, BooleanFormula>();

    Z3UserPropagator(long ctx, long solver, Z3FormulaCreator creator, Z3FormulaManager manager, UserPropagator userPropagator) {
        super(ctx, solver);
        this.creator = creator;
        this.userPropagator = userPropagator;
        this.manager = manager;
        this.z3True = creator.extractInfo(((AbstractBooleanFormulaManager)manager.getBooleanFormulaManager()).makeTrue());
        this.z3False = creator.extractInfo(((AbstractBooleanFormulaManager)manager.getBooleanFormulaManager()).makeFalse());
    }

    protected void pushWrapper() {
        this.userPropagator.onPush();
    }

    protected void popWrapper(int num) {
        this.userPropagator.onPop(num);
    }

    protected void finWrapper() {
        this.userPropagator.onFinalCheck();
    }

    protected void eqWrapper(long pL, long pL1) {
    }

    protected void fixedWrapper(long lvar, long lvalue) {
        assert (lvalue == this.z3True || lvalue == this.z3False);
        this.userPropagator.onKnownValue(this.encapsulate(lvar), lvalue == this.z3True);
    }

    protected Z3UserPropagator freshWrapper(long lctx) {
        return this;
    }

    protected void createdWrapper(long le) {
    }

    protected void decideWrapper(long lvar, int bit, boolean isPositive) {
        this.userPropagator.onDecision(this.encapsulate(lvar), isPositive);
    }

    @Override
    public void registerExpression(BooleanFormula exprToWatch) {
        Native.propagateAdd((Object)this, (long)this.ctx, (long)this.solver, (long)this.javainfo, (long)this.creator.extractInfo(exprToWatch));
    }

    @Override
    public void notifyOnKnownValue() {
        this.registerFixed();
    }

    @Override
    public void notifyOnDecision() {
        this.registerDecide();
    }

    @Override
    public void notifyOnFinalCheck() {
        this.registerFinal();
    }

    @Override
    public void propagateConflict(BooleanFormula[] conflictExpressions) {
        this.propagateConsequence(conflictExpressions, ((AbstractBooleanFormulaManager)this.manager.getBooleanFormulaManager()).makeFalse());
    }

    @Override
    public void propagateConsequence(BooleanFormula[] assignedLiterals, BooleanFormula consequence) {
        long[] emptyEqs = new long[]{};
        Native.propagateConsequence((Object)this, (long)this.ctx, (long)this.solver, (long)this.javainfo, (int)assignedLiterals.length, (long[])this.extractInfoFromArray(assignedLiterals), (long)emptyEqs.length, (long[])emptyEqs, (long[])emptyEqs, (long)this.creator.extractInfo(consequence));
    }

    @Override
    public boolean propagateNextDecision(BooleanFormula expr, Optional<Boolean> value) {
        Status status = value.map(pBoolean -> pBoolean != false ? Status.SATISFIABLE : Status.UNSATISFIABLE).orElse(Status.UNKNOWN);
        int index = 0;
        return Native.propagateNextSplit((Object)this, (long)this.ctx, (long)this.solver, (long)this.javainfo, (long)this.creator.extractInfo(expr), (long)index, (int)status.toInt());
    }

    private long[] extractInfoFromArray(BooleanFormula[] formulaArray) {
        long[] formulaInfos = new long[formulaArray.length];
        for (int i = 0; i < formulaArray.length; ++i) {
            if (formulaArray[i] == null) continue;
            formulaInfos[i] = this.creator.extractInfo(formulaArray[i]);
        }
        return formulaInfos;
    }

    private BooleanFormula encapsulate(long z3Expr) {
        return this.canonicalizer.computeIfAbsent(Long.rotateRight(z3Expr, 3), key -> this.creator.encapsulateBoolean(z3Expr));
    }

    public void close() {
        this.canonicalizer.clear();
        super.close();
    }
}

