/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;

class SmtInterpolArrayFormulaManager
extends AbstractArrayFormulaManager<Term, Sort, Script, FunctionSymbol> {
    private final Script env;

    SmtInterpolArrayFormulaManager(SmtInterpolFormulaCreator pCreator) {
        super(pCreator);
        this.env = (Script)pCreator.getEnv();
    }

    @Override
    protected Term select(Term pArray, Term pIndex) {
        return this.env.term("select", new Term[]{pArray, pIndex});
    }

    @Override
    protected Term store(Term pArray, Term pIndex, Term pValue) {
        return this.env.term("store", new Term[]{pArray, pIndex, pValue});
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Term internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        Sort smtInterpolArrayType = (Sort)this.toSolverType(FormulaType.getArrayType(pIndexType, pElementType));
        return (Term)this.getFormulaCreator().makeVariable(smtInterpolArrayType, pName);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Term internalMakeArray(FormulaType<TI> pIndexType, FormulaType<TE> pElementType, Term elseElem) {
        Sort arraySort = (Sort)this.toSolverType(FormulaType.getArrayType(pIndexType, pElementType));
        return this.env.term("const", null, arraySort, new Term[]{elseElem});
    }

    @Override
    protected Term equivalence(Term pArray1, Term pArray2) {
        return this.env.term("=", new Term[]{pArray1, pArray2});
    }
}

