/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFormulaITE;
import ap.parser.INot;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import ap.types.Sort;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFunctionDeclaration;
import scala.Enumeration;

class PrincessBooleanFormulaManager
extends AbstractBooleanFormulaManager<IExpression, Sort, PrincessEnvironment, PrincessFunctionDeclaration> {
    private final IBoolLit pTrue = new IBoolLit(true);
    private final IBoolLit pFalse = new IBoolLit(false);

    PrincessBooleanFormulaManager(PrincessFormulaCreator creator) {
        super(creator);
    }

    @Override
    public IFormula makeVariableImpl(String varName) {
        return (IFormula)this.getFormulaCreator().makeVariable((Sort)this.getFormulaCreator().getBoolType(), varName);
    }

    @Override
    public IFormula makeBooleanImpl(boolean pValue) {
        return pValue ? this.pTrue : this.pFalse;
    }

    @Override
    public IFormula equivalence(IExpression t1, IExpression t2) {
        return new IBinFormula(IBinJunctor.Eqv(), (IFormula)t1, (IFormula)t2);
    }

    @Override
    public boolean isTrue(IExpression t) {
        return t instanceof IBoolLit && ((IBoolLit)t).value();
    }

    @Override
    public boolean isFalse(IExpression t) {
        return t instanceof IBoolLit && !((IBoolLit)t).value();
    }

    @Override
    public IExpression ifThenElse(IExpression condition, IExpression t1, IExpression t2) {
        if (this.isTrue(condition)) {
            return t1;
        }
        if (this.isFalse(condition)) {
            return t2;
        }
        if (t1.equals(t2)) {
            return t1;
        }
        if (this.isTrue(t1) && this.isFalse(t2)) {
            return condition;
        }
        if (this.isFalse(t1) && this.isTrue(t2)) {
            return this.not(condition);
        }
        if (t1 instanceof IFormula) {
            return new IFormulaITE((IFormula)condition, (IFormula)t1, (IFormula)t2);
        }
        return new ITermITE((IFormula)condition, (ITerm)t1, (ITerm)t2);
    }

    @Override
    public IFormula not(IExpression pBits) {
        if (this.isTrue(pBits)) {
            return this.pFalse;
        }
        if (this.isFalse(pBits)) {
            return this.pTrue;
        }
        if (pBits instanceof INot) {
            return ((INot)pBits).subformula();
        }
        return new INot((IFormula)pBits);
    }

    @Override
    public IFormula and(IExpression t1, IExpression t2) {
        if (t1 == t2) {
            return (IFormula)t1;
        }
        if (this.isTrue(t1)) {
            return (IFormula)t2;
        }
        if (this.isTrue(t2)) {
            return (IFormula)t1;
        }
        if (this.isFalse(t1)) {
            return this.pFalse;
        }
        if (this.isFalse(t2)) {
            return this.pFalse;
        }
        return this.simplify((IFormula)new IBinFormula(IBinJunctor.And(), (IFormula)t1, (IFormula)t2));
    }

    @Override
    public IFormula or(IExpression t1, IExpression t2) {
        if (t1 == t2) {
            return (IFormula)t1;
        }
        if (this.isTrue(t1)) {
            return this.pTrue;
        }
        if (this.isTrue(t2)) {
            return this.pTrue;
        }
        if (this.isFalse(t1)) {
            return (IFormula)t2;
        }
        if (this.isFalse(t2)) {
            return (IFormula)t1;
        }
        return this.simplify((IFormula)new IBinFormula(IBinJunctor.Or(), (IFormula)t1, (IFormula)t2));
    }

    private IFormula simplify(IFormula f) {
        Enumeration.Value innerOperator;
        IBinFormula bin;
        Enumeration.Value operator;
        if (f instanceof IBinFormula && this.isDistributiveBooleanOperator(operator = (bin = (IBinFormula)f).j()) && bin.f1() instanceof IBinFormula && bin.f2() instanceof IBinFormula && ((IBinFormula)bin.f1()).j().equals((Object)((IBinFormula)bin.f2()).j()) && this.isDistributiveBooleanOperator(innerOperator = ((IBinFormula)bin.f1()).j())) {
            IFormula s11 = ((IBinFormula)bin.f1()).f1();
            IFormula s12 = ((IBinFormula)bin.f1()).f2();
            IFormula s21 = ((IBinFormula)bin.f2()).f1();
            IFormula s22 = ((IBinFormula)bin.f2()).f2();
            if (s11 == s21) {
                return new IBinFormula(innerOperator, s11, (IFormula)new IBinFormula(operator, s12, s22));
            }
            if (s11 == s22) {
                return new IBinFormula(innerOperator, s11, (IFormula)new IBinFormula(operator, s12, s21));
            }
            if (s12 == s21) {
                return new IBinFormula(innerOperator, s12, (IFormula)new IBinFormula(operator, s11, s22));
            }
            if (s12 == s22) {
                return new IBinFormula(innerOperator, s12, (IFormula)new IBinFormula(operator, s11, s21));
            }
        }
        return f;
    }

    private boolean isDistributiveBooleanOperator(Enumeration.Value operator) {
        return IBinJunctor.And().equals((Object)operator) || IBinJunctor.Or().equals((Object)operator);
    }

    @Override
    public IFormula xor(IExpression t1, IExpression t2) {
        return new INot((IFormula)new IBinFormula(IBinJunctor.Eqv(), (IFormula)t1, (IFormula)t2));
    }
}

