/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.parser.IExpression;
import ap.parser.ITerm;
import ap.theories.arrays.ExtArray;
import ap.types.Sort;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFunctionDeclaration;

class PrincessArrayFormulaManager
extends AbstractArrayFormulaManager<IExpression, Sort, PrincessEnvironment, PrincessFunctionDeclaration> {
    private final PrincessEnvironment env;

    PrincessArrayFormulaManager(FormulaCreator<IExpression, Sort, PrincessEnvironment, PrincessFunctionDeclaration> pFormulaCreator) {
        super(pFormulaCreator);
        this.env = pFormulaCreator.getEnv();
    }

    @Override
    protected IExpression select(IExpression pArray, IExpression pIndex) {
        return this.env.makeSelect((ITerm)pArray, (ITerm)pIndex);
    }

    @Override
    protected IExpression store(IExpression pArray, IExpression pIndex, IExpression pValue) {
        return this.env.makeStore((ITerm)pArray, (ITerm)pIndex, (ITerm)pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> IExpression internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        Sort arrayType = (Sort)this.toSolverType(FormulaType.getArrayType(pIndexType, pElementType));
        return (IExpression)this.getFormulaCreator().makeVariable(arrayType, pName);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> IExpression internalMakeArray(FormulaType<TI> pIndexType, FormulaType<TE> pElementType, IExpression elseElem) {
        Sort arrayType = (Sort)this.toSolverType(FormulaType.getArrayType(pIndexType, pElementType));
        return this.env.makeConstArray((ExtArray.ArraySort)arrayType, (ITerm)elseElem);
    }

    @Override
    protected IExpression equivalence(IExpression pArray1, IExpression pArray2) {
        return IExpression.Eq$.MODULE$.apply((ITerm)pArray1, (ITerm)pArray2);
    }
}

