/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Kind;
import io.github.cvc5.Solver;
import io.github.cvc5.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5AbstractProver;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;

public class CVC5InterpolatingProver
extends CVC5AbstractProver<String>
implements InterpolatingProverEnvironment<String> {
    private final FormulaManager mgr;
    private final Set<SolverContext.ProverOptions> solverOptions;
    private final int seed;
    private final CVC5BooleanFormulaManager bmgr;
    private final boolean validateInterpolants;

    CVC5InterpolatingProver(CVC5FormulaCreator pFormulaCreator, ShutdownNotifier pShutdownNotifier, int randomSeed, Set<SolverContext.ProverOptions> pOptions, FormulaManager pMgr, boolean pValidateInterpolants) {
        super(pFormulaCreator, pShutdownNotifier, randomSeed, pOptions, pMgr);
        this.mgr = pMgr;
        this.solverOptions = pOptions;
        this.seed = randomSeed;
        this.bmgr = (CVC5BooleanFormulaManager)this.mgr.getBooleanFormulaManager();
        this.validateInterpolants = pValidateInterpolants;
    }

    @Override
    protected void setSolverOptions(int randomSeed, Set<SolverContext.ProverOptions> pOptions, Solver pSolver) {
        super.setSolverOptions(randomSeed, pOptions, pSolver);
        pSolver.setOption("produce-interpolants", "true");
    }

    @Override
    protected String addConstraintImpl(BooleanFormula constraint) throws InterruptedException {
        return super.addConstraint0(constraint);
    }

    @Override
    public BooleanFormula getInterpolant(Collection<String> pFormulasOfA) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.getAssertedConstraintIds().containsAll(pFormulasOfA), (Object)"interpolation can only be done over previously asserted formulas.");
        ImmutableSet assertedFormulas = Collections3.transformedImmutableSetCopy(this.getAssertedFormulas(), this.creator::extractInfo);
        ImmutableSet formulasOfA = Collections3.transformedImmutableSetCopy(pFormulasOfA, arg_0 -> ((PersistentMap)this.assertedTerms.peek()).get(arg_0));
        Sets.SetView formulasOfB = Sets.difference((Set)assertedFormulas, (Set)formulasOfA);
        Term itp = this.getCVC5Interpolation((Collection<Term>)formulasOfA, (Collection<Term>)formulasOfB);
        return this.creator.encapsulateBoolean(itp);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<String>> partitions) throws SolverException, InterruptedException {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"at least one partition should be available.");
        ImmutableSet assertedConstraintIds = this.getAssertedConstraintIds();
        Preconditions.checkArgument((boolean)partitions.stream().allMatch(arg_0 -> assertedConstraintIds.containsAll(arg_0)), (Object)"interpolation can only be done over previously asserted formulas.");
        int n = partitions.size();
        ArrayList<BooleanFormula> itps = new ArrayList<BooleanFormula>();
        Term previousItp = this.solver.mkTrue();
        for (int i = 1; i < n; ++i) {
            ImmutableSet formulasA = FluentIterable.from((Iterable)partitions.get(i - 1)).transform(arg_0 -> ((PersistentMap)this.assertedTerms.peek()).get(arg_0)).append((Iterable)previousItp).toSet();
            ImmutableSet formulasB = FluentIterable.concat(partitions.subList(i, n)).transform(arg_0 -> ((PersistentMap)this.assertedTerms.peek()).get(arg_0)).toSet();
            Term itp = this.getCVC5Interpolation((Collection<Term>)formulasA, (Collection<Term>)formulasB);
            itps.add(this.creator.encapsulateBoolean(itp));
            previousItp = itp;
        }
        return itps;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<String>> partitionedFormulas, int[] startOfSubTree) {
        throw new UnsupportedOperationException("directly receiving tree interpolants is not supported.Use another solver or another strategy for interpolants.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Term getCVC5Interpolation(Collection<Term> formulasA, Collection<Term> formulasB) {
        Term interpolant;
        Term phiPlus = this.bmgr.andImpl(formulasA);
        Term phiMinus = this.bmgr.andImpl(formulasB);
        Solver itpSolver = new Solver();
        this.setSolverOptions(this.seed, this.solverOptions, itpSolver);
        try {
            itpSolver.assertFormula(phiPlus);
            interpolant = itpSolver.getInterpolant(itpSolver.mkTerm(Kind.NOT, phiMinus));
        }
        finally {
            itpSolver.deletePointer();
        }
        if (this.validateInterpolants) {
            this.checkInterpolationCriteria(interpolant, phiPlus, phiMinus);
        }
        return interpolant;
    }

    private void checkInterpolationCriteria(Term interpolant, Term phiPlus, Term phiMinus) {
        ImmutableSet interpolantSymbols = this.mgr.extractVariablesAndUFs(this.creator.encapsulateBoolean(interpolant)).keySet();
        ImmutableSet interpolASymbols = this.mgr.extractVariablesAndUFs(this.creator.encapsulateBoolean(phiPlus)).keySet();
        ImmutableSet interpolBSymbols = this.mgr.extractVariablesAndUFs(this.creator.encapsulateBoolean(phiMinus)).keySet();
        Sets.SetView intersection = Sets.intersection((Set)interpolASymbols, (Set)interpolBSymbols);
        Preconditions.checkState((boolean)intersection.containsAll((Collection<?>)interpolantSymbols), (String)"Interpolant contains symbols %s that are not part of both input formulas.", (Object)Sets.difference((Set)interpolantSymbols, (Set)intersection));
        Solver validationSolver = new Solver();
        super.setSolverOptions(this.seed, this.solverOptions, validationSolver);
        try {
            validationSolver.push();
            validationSolver.assertFormula(validationSolver.mkTerm(Kind.IMPLIES, phiPlus, interpolant));
            Preconditions.checkState((boolean)validationSolver.checkSat().isSat(), (Object)"Invalid Craig interpolation: phi+ does not imply the interpolant.");
            validationSolver.pop();
            validationSolver.push();
            validationSolver.assertFormula(validationSolver.mkTerm(Kind.AND, interpolant, phiMinus));
            Preconditions.checkState((boolean)validationSolver.checkSat().isUnsat(), (Object)"Invalid Craig interpolation: interpolant does not contradict phi-.");
            validationSolver.pop();
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("Failure when validating interpolant '" + interpolant + "'.", e);
        }
        finally {
            validationSolver.deletePointer();
        }
    }
}

