/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.Kind;
import edu.stanford.CVC4.SmtEngine;
import edu.stanford.CVC4.Type;
import edu.stanford.CVC4.vectorExpr;
import java.util.List;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;

public class CVC4QuantifiedFormulaManager
extends AbstractQuantifiedFormulaManager<Expr, Type, ExprManager, Expr> {
    private final ExprManager exprManager;

    protected CVC4QuantifiedFormulaManager(FormulaCreator<Expr, Type, ExprManager, Expr> pFormulaCreator) {
        super(pFormulaCreator);
        this.exprManager = pFormulaCreator.getEnv();
    }

    @Override
    protected Expr eliminateQuantifiers(Expr pExtractInfo) throws SolverException, InterruptedException {
        SmtEngine smtEngine = new SmtEngine(this.exprManager);
        Expr eliminated = pExtractInfo;
        try {
            eliminated = smtEngine.doQuantifierElimination(pExtractInfo, true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        smtEngine.delete();
        return eliminated;
    }

    @Override
    public Expr mkQuantifier(QuantifiedFormulaManager.Quantifier pQ, List<Expr> pVars, Expr pBody) {
        if (pVars.isEmpty()) {
            throw new IllegalArgumentException("Empty variable list for quantifier.");
        }
        vectorExpr vec = new vectorExpr();
        Expr substBody = pBody;
        for (Expr var : pVars) {
            Expr boundCopy = ((CVC4FormulaCreator)this.formulaCreator).makeBoundCopy(var);
            vec.add(boundCopy);
            substBody = substBody.substitute(var, boundCopy);
        }
        Expr quantifiedVars = this.exprManager.mkExpr(Kind.BOUND_VAR_LIST, vec);
        Kind quant = pQ == QuantifiedFormulaManager.Quantifier.EXISTS ? Kind.EXISTS : Kind.FORALL;
        return this.exprManager.mkExpr(quant, quantifiedVars, substBody);
    }
}

