/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.collect.Iterables;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.Kind;
import edu.stanford.CVC4.Type;
import edu.stanford.CVC4.vectorExpr;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;

public class CVC4BooleanFormulaManager
extends AbstractBooleanFormulaManager<Expr, Type, ExprManager, Expr> {
    private final Expr cvc4True;
    private final Expr cvc4False;
    private final ExprManager exprManager;

    protected CVC4BooleanFormulaManager(CVC4FormulaCreator pCreator) {
        super(pCreator);
        this.exprManager = (ExprManager)pCreator.getEnv();
        this.cvc4True = this.exprManager.mkConst(true);
        this.cvc4False = this.exprManager.mkConst(false);
    }

    @Override
    protected Expr makeVariableImpl(String pVar) {
        return (Expr)this.formulaCreator.makeVariable((Type)this.getFormulaCreator().getBoolType(), pVar);
    }

    @Override
    protected Expr makeBooleanImpl(boolean pValue) {
        return pValue ? this.cvc4True : this.cvc4False;
    }

    @Override
    protected Expr not(Expr pParam1) {
        if (this.isTrue(pParam1)) {
            return this.cvc4False;
        }
        if (this.isFalse(pParam1)) {
            return this.cvc4True;
        }
        if (pParam1.getKind() == Kind.NOT) {
            return pParam1.getChild(0L);
        }
        return this.exprManager.mkExpr(Kind.NOT, pParam1);
    }

    @Override
    protected Expr and(Expr pParam1, Expr pParam2) {
        if (this.isTrue(pParam1)) {
            return pParam2;
        }
        if (this.isTrue(pParam2)) {
            return pParam1;
        }
        if (this.isFalse(pParam1)) {
            return this.cvc4False;
        }
        if (this.isFalse(pParam2)) {
            return this.cvc4False;
        }
        if (pParam1 == pParam2) {
            return pParam1;
        }
        return this.exprManager.mkExpr(Kind.AND, pParam1, pParam2);
    }

    @Override
    protected Expr andImpl(Collection<Expr> pParams) {
        LinkedHashSet<Expr> operands = new LinkedHashSet<Expr>();
        for (Expr operand : pParams) {
            if (this.isFalse(operand)) {
                return this.cvc4False;
            }
            if (this.isTrue(operand)) continue;
            operands.add(operand);
        }
        switch (operands.size()) {
            case 0: {
                return this.cvc4True;
            }
            case 1: {
                return (Expr)Iterables.getOnlyElement(operands);
            }
        }
        vectorExpr vExpr = new vectorExpr();
        for (Expr e : operands) {
            vExpr.add(e);
        }
        return this.exprManager.mkExpr(Kind.AND, vExpr);
    }

    @Override
    protected Expr or(Expr pParam1, Expr pParam2) {
        if (this.isTrue(pParam1)) {
            return this.cvc4True;
        }
        if (this.isTrue(pParam2)) {
            return this.cvc4True;
        }
        if (this.isFalse(pParam1)) {
            return pParam2;
        }
        if (this.isFalse(pParam2)) {
            return pParam1;
        }
        if (pParam1 == pParam2) {
            return pParam1;
        }
        return this.exprManager.mkExpr(Kind.OR, pParam1, pParam2);
    }

    @Override
    protected Expr orImpl(Collection<Expr> pParams) {
        LinkedHashSet<Expr> operands = new LinkedHashSet<Expr>();
        for (Expr operand : pParams) {
            if (this.isTrue(operand)) {
                return this.cvc4True;
            }
            if (this.isFalse(operand)) continue;
            operands.add(operand);
        }
        switch (operands.size()) {
            case 0: {
                return this.cvc4False;
            }
            case 1: {
                return (Expr)Iterables.getOnlyElement(operands);
            }
        }
        vectorExpr vExpr = new vectorExpr();
        for (Expr e : operands) {
            vExpr.add(e);
        }
        return this.exprManager.mkExpr(Kind.OR, vExpr);
    }

    @Override
    protected Expr xor(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.XOR, pParam1, pParam2);
    }

    @Override
    protected Expr equivalence(Expr pBits1, Expr pBits2) {
        return this.exprManager.mkExpr(Kind.EQUAL, pBits1, pBits2);
    }

    @Override
    protected Expr implication(Expr bits1, Expr bits2) {
        return this.exprManager.mkExpr(Kind.IMPLIES, bits1, bits2);
    }

    @Override
    protected boolean isTrue(Expr pBits) {
        return pBits.isConst() && pBits.getKind() == Kind.CONST_BOOLEAN && pBits.getConstBoolean();
    }

    @Override
    protected boolean isFalse(Expr pBits) {
        return pBits.isConst() && pBits.getKind() == Kind.CONST_BOOLEAN && !pBits.getConstBoolean();
    }

    @Override
    protected Expr ifThenElse(Expr pCond, Expr pF1, Expr pF2) {
        if (this.isTrue(pCond)) {
            return pF1;
        }
        if (this.isFalse(pCond)) {
            return pF2;
        }
        if (pF1.equals(pF2)) {
            return pF1;
        }
        if (this.isTrue(pF1) && this.isFalse(pF2)) {
            return pCond;
        }
        if (this.isFalse(pF1) && this.isTrue(pF2)) {
            return this.not(pCond);
        }
        return this.exprManager.mkExpr(Kind.ITE, pCond, pF1, pF2);
    }
}

