/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.basicimpl.CachingModel;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormula;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaCreator;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaModel;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Bitwuzla;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Option;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Options;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Result;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Term;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Terminator;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Vector_Term;

class BitwuzlaTheoremProver
extends AbstractProverWithAllSat<Void>
implements ProverEnvironment {
    private final Terminator terminator = new Terminator(){

        public boolean terminate() {
            return BitwuzlaTheoremProver.this.shutdownNotifier.shouldShutdown();
        }
    };
    private final Bitwuzla env;
    private final BitwuzlaFormulaManager manager;
    private final BitwuzlaFormulaCreator creator;
    protected boolean wasLastSatCheckSat = false;

    protected BitwuzlaTheoremProver(BitwuzlaFormulaManager pManager, BitwuzlaFormulaCreator pCreator, ShutdownNotifier pShutdownNotifier, Set<SolverContext.ProverOptions> pOptions, Options pSolverOptions) {
        super(pOptions, pManager.getBooleanFormulaManager(), pShutdownNotifier);
        this.manager = pManager;
        this.creator = pCreator;
        this.env = this.createEnvironment(pOptions, pSolverOptions);
        this.env.configure_terminator(this.terminator);
    }

    private Bitwuzla createEnvironment(Set<SolverContext.ProverOptions> pProverOptions, Options pSolverOptions) {
        if (pProverOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS) || pProverOptions.contains((Object)SolverContext.ProverOptions.GENERATE_ALL_SAT)) {
            pSolverOptions.set(Option.PRODUCE_MODELS, 2);
        }
        if (pProverOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE)) {
            pSolverOptions.set(Option.PRODUCE_UNSAT_CORES, 2);
        }
        if (pProverOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS)) {
            pSolverOptions.set(Option.PRODUCE_UNSAT_ASSUMPTIONS, 2);
        }
        return new Bitwuzla(this.creator.getTermManager(), pSolverOptions);
    }

    @Override
    public void popImpl() {
        this.env.pop(1L);
    }

    @Override
    public @Nullable Void addConstraintImpl(BooleanFormula constraint) throws InterruptedException {
        this.wasLastSatCheckSat = false;
        this.env.assert_formula(((BitwuzlaFormula.BitwuzlaBooleanFormula)constraint).getTerm());
        return null;
    }

    @Override
    public void pushImpl() throws InterruptedException {
        this.env.push(1L);
    }

    private boolean readSATResult(Result resultValue) throws SolverException, InterruptedException {
        if (resultValue == Result.SAT) {
            this.wasLastSatCheckSat = true;
            return false;
        }
        if (resultValue == Result.UNSAT) {
            return true;
        }
        if (resultValue == Result.UNKNOWN && this.shutdownNotifier.shouldShutdown()) {
            throw new InterruptedException();
        }
        throw new SolverException("Bitwuzla returned UNKNOWN.");
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        Result result = this.env.check_sat(new Vector_Term(this.creator.getVariableCasts()));
        return this.readSATResult(result);
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        Vector_Term ass = new Vector_Term(this.creator.getVariableCasts());
        for (BooleanFormula formula : assumptions) {
            BitwuzlaFormula.BitwuzlaBooleanFormula bitwuzlaFormula = (BitwuzlaFormula.BitwuzlaBooleanFormula)formula;
            ass.add(bitwuzlaFormula.getTerm());
        }
        Result result = this.env.check_sat(ass);
        return this.readSATResult(result);
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.wasLastSatCheckSat, (Object)"Model computation failed. Are the pushed formulae satisfiable?");
        this.checkGenerateModels();
        return new CachingModel(this.registerEvaluator(new BitwuzlaModel(this.env, this, this.creator, Collections2.transform(this.getAssertedFormulas(), this.creator::extractInfo))));
    }

    private List<BooleanFormula> getUnsatCore0() {
        ArrayList<BooleanFormula> wrapped = new ArrayList<BooleanFormula>();
        for (Term term : this.env.get_unsat_core()) {
            wrapped.add(this.creator.encapsulateBoolean(term));
        }
        return wrapped;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        Preconditions.checkState((!this.wasLastSatCheckSat ? 1 : 0) != 0);
        return this.getUnsatCore0();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        Preconditions.checkNotNull(assumptions);
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        Preconditions.checkState((!this.wasLastSatCheckSat ? 1 : 0) != 0);
        boolean sat = !this.isUnsatWithAssumptions(assumptions);
        return sat ? Optional.empty() : Optional.of(this.getUnsatCore0());
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.env.delete();
        }
        super.close();
    }

    @Override
    protected BitwuzlaModel getEvaluatorWithoutChecks() {
        return this.registerEvaluator(new BitwuzlaModel(this.env, this, this.creator, Collections2.transform(this.getAssertedFormulas(), this.creator::extractInfo)));
    }

    public boolean isClosed() {
        return this.closed;
    }
}

