/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaBitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFloatingPointManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaCreator;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaQuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaTheoremProver;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaUFManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.BitwuzlaNative;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Option;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Options;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.TermManager;

public final class BitwuzlaSolverContext
extends AbstractSolverContext {
    private final BitwuzlaFormulaManager manager;
    private final BitwuzlaFormulaCreator creator;
    private final ShutdownNotifier shutdownNotifier;
    private final Options solverOptions;
    private boolean closed = false;

    BitwuzlaSolverContext(BitwuzlaFormulaManager pManager, BitwuzlaFormulaCreator pCreator, ShutdownNotifier pShutdownNotifier, Options pOptions) {
        super(pManager);
        this.manager = pManager;
        this.creator = pCreator;
        this.shutdownNotifier = pShutdownNotifier;
        this.solverOptions = pOptions;
    }

    public static BitwuzlaSolverContext create(Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogfile, long randomSeed, FloatingPointRoundingMode pFloatingPointRoundingMode, Consumer<String> pLoader) throws InvalidConfigurationException {
        BitwuzlaSolverContext.loadLibrary(pLoader);
        TermManager termManager = new TermManager();
        Options solverOptions = BitwuzlaSolverContext.buildBitwuzlaOptions(new BitwuzlaSettings(config), randomSeed);
        BitwuzlaFormulaCreator creator = new BitwuzlaFormulaCreator(termManager);
        BitwuzlaUFManager functionTheory = new BitwuzlaUFManager(creator);
        BitwuzlaBooleanFormulaManager booleanTheory = new BitwuzlaBooleanFormulaManager(creator);
        BitwuzlaBitvectorFormulaManager bitvectorTheory = new BitwuzlaBitvectorFormulaManager(creator, booleanTheory);
        BitwuzlaQuantifiedFormulaManager quantifierTheory = new BitwuzlaQuantifiedFormulaManager(creator);
        BitwuzlaFloatingPointManager floatingPointTheory = new BitwuzlaFloatingPointManager(creator, pFloatingPointRoundingMode);
        BitwuzlaArrayFormulaManager arrayTheory = new BitwuzlaArrayFormulaManager(creator);
        BitwuzlaFormulaManager manager = new BitwuzlaFormulaManager(creator, functionTheory, booleanTheory, bitvectorTheory, quantifierTheory, floatingPointTheory, arrayTheory, solverOptions);
        return new BitwuzlaSolverContext(manager, creator, pShutdownNotifier, solverOptions);
    }

    @VisibleForTesting
    static void loadLibrary(Consumer<String> pLoader) {
        BitwuzlaSolverContext.loadLibrariesWithFallback(pLoader, (List<String>)ImmutableList.of((Object)"bitwuzlaj"), (List<String>)ImmutableList.of((Object)"libbitwuzlaj"));
    }

    private static Options setFurtherOptions(Options pOptions, String pFurtherOptions) throws InvalidConfigurationException {
        ImmutableMap furtherOptionsMap;
        Splitter.MapSplitter optionSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator(Splitter.on((char)'=').limit(2).trimResults());
        try {
            furtherOptionsMap = ImmutableMap.copyOf((Map)optionSplitter.split((CharSequence)pFurtherOptions));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("Invalid Bitwuzla option in \"" + pFurtherOptions + "\": " + e.getMessage(), (Throwable)e);
        }
        for (Map.Entry option : furtherOptionsMap.entrySet()) {
            String optionName = (String)option.getKey();
            String optionValue = (String)option.getValue();
            Option bitwuzlaOption = BitwuzlaSolverContext.getBitwuzlaOptByString(optionName);
            try {
                if (pOptions.is_numeric(bitwuzlaOption)) {
                    pOptions.set(bitwuzlaOption, Integer.parseInt(optionValue));
                    continue;
                }
                pOptions.set(bitwuzlaOption, (String)option.getValue());
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Option " + bitwuzlaOption + " needs a numeric value as option value, but you entered " + optionValue);
            }
        }
        return pOptions;
    }

    private static Options buildBitwuzlaOptions(BitwuzlaSettings settings, long randomSeed) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)((Object)settings.getSatSolver()));
        Options options = new Options();
        options.set(Option.SAT_SOLVER, settings.getSatSolver().name().toLowerCase(Locale.getDefault()));
        options.set(Option.SEED, (int)randomSeed);
        options.set(Option.REWRITE_LEVEL, 0);
        return BitwuzlaSolverContext.setFurtherOptions(options, settings.getFurtherOptions());
    }

    @Override
    public String getVersion() {
        return "Bitwuzla " + BitwuzlaNative.version();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.BITWUZLA;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.creator.getTermManager().delete();
            this.closed = true;
        }
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"solver context is already closed");
        return new BitwuzlaTheoremProver(this.manager, this.creator, this.shutdownNotifier, options, this.solverOptions);
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> pF) {
        throw new UnsupportedOperationException("Bitwuzla does not support interpolation");
    }

    @Override
    protected OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> pSet) {
        throw new UnsupportedOperationException("Bitwuzla does not support optimization");
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return true;
    }

    public static Option getBitwuzlaOptByString(String optionName) {
        switch (optionName) {
            case "LOGLEVEL": {
                return Option.LOGLEVEL;
            }
            case "PRODUCE_MODELS": {
                return Option.PRODUCE_MODELS;
            }
            case "PRODUCE_UNSAT_ASSUMPTIONS": {
                return Option.PRODUCE_UNSAT_ASSUMPTIONS;
            }
            case "PRODUCE_UNSAT_CORES": {
                return Option.PRODUCE_UNSAT_CORES;
            }
            case "SEED": {
                return Option.SEED;
            }
            case "VERBOSITY": {
                return Option.VERBOSITY;
            }
            case "TIME_LIMIT_PER": {
                return Option.TIME_LIMIT_PER;
            }
            case "MEMORY_LIMIT": {
                return Option.MEMORY_LIMIT;
            }
            case "BV_SOLVER": {
                return Option.BV_SOLVER;
            }
            case "REWRITE_LEVEL": {
                return Option.REWRITE_LEVEL;
            }
            case "SAT_SOLVER": {
                return Option.SAT_SOLVER;
            }
            case "PROP_CONST_BITS": {
                return Option.PROP_CONST_BITS;
            }
            case "PROP_INFER_INEQ_BOUNDS": {
                return Option.PROP_INFER_INEQ_BOUNDS;
            }
            case "PROP_NPROPS": {
                return Option.PROP_NPROPS;
            }
            case "PROP_NUPDATES": {
                return Option.PROP_NUPDATES;
            }
            case "PROP_OPT_LT_CONCAT_SEXT": {
                return Option.PROP_OPT_LT_CONCAT_SEXT;
            }
            case "PROP_PATH_SEL": {
                return Option.PROP_PATH_SEL;
            }
            case "PROP_PROB_RANDOM_INPUT": {
                return Option.PROP_PROB_RANDOM_INPUT;
            }
            case "PROP_PROB_USE_INV_VALUE": {
                return Option.PROP_PROB_USE_INV_VALUE;
            }
            case "PROP_SEXT": {
                return Option.PROP_SEXT;
            }
            case "PROP_NORMALIZE": {
                return Option.PROP_NORMALIZE;
            }
            case "PREPROCESS": {
                return Option.PREPROCESS;
            }
            case "PP_CONTRADICTING_ANDS": {
                return Option.PP_CONTRADICTING_ANDS;
            }
            case "PP_ELIM_BV_EXTRACTS": {
                return Option.PP_ELIM_BV_EXTRACTS;
            }
            case "PP_EMBEDDED_CONSTR": {
                return Option.PP_EMBEDDED_CONSTR;
            }
            case "PP_FLATTEN_AND": {
                return Option.PP_FLATTEN_AND;
            }
            case "PP_NORMALIZE": {
                return Option.PP_NORMALIZE;
            }
            case "PP_NORMALIZE_SHARE_AWARE": {
                return Option.PP_NORMALIZE_SHARE_AWARE;
            }
            case "PP_SKELETON_PREPROC": {
                return Option.PP_SKELETON_PREPROC;
            }
            case "PP_VARIABLE_SUBST": {
                return Option.PP_VARIABLE_SUBST;
            }
            case "PP_VARIABLE_SUBST_NORM_EQ": {
                return Option.PP_VARIABLE_SUBST_NORM_EQ;
            }
            case "PP_VARIABLE_SUBST_NORM_DISEQ": {
                return Option.PP_VARIABLE_SUBST_NORM_DISEQ;
            }
            case "PP_VARIABLE_SUBST_NORM_BV_INEQ": {
                return Option.PP_VARIABLE_SUBST_NORM_BV_INEQ;
            }
            case "DBG_RW_NODE_THRESH": {
                return Option.DBG_RW_NODE_THRESH;
            }
            case "DBG_PP_NODE_THRESH": {
                return Option.DBG_PP_NODE_THRESH;
            }
            case "DBG_CHECK_MODEL": {
                return Option.DBG_CHECK_MODEL;
            }
            case "DBG_CHECK_UNSAT_CORE": {
                return Option.DBG_CHECK_UNSAT_CORE;
            }
            case "NUM_OPTS": {
                return Option.NUM_OPTS;
            }
        }
        throw new IllegalArgumentException("Unknown option: " + optionName + ". Please use the C++ options of Bitwuzla.");
    }

    @org.sosy_lab.common.configuration.Options(prefix="solver.bitwuzla")
    public static class BitwuzlaSettings {
        @org.sosy_lab.common.configuration.Option(secure=true, description="The SAT solver used by Bitwuzla.")
        private SatSolver satSolver = SatSolver.CADICAL;
        @org.sosy_lab.common.configuration.Option(secure=true, description="Further options for Bitwuzla in addition to the default options. Format:  \"option_name=value\" with \u2019,\u2019 to separate options. Option names and values can be found in the Bitwuzla documentation online:https://bitwuzla.github.io/docs/cpp/enums/option.html#_CPPv4N8bitwuzla6OptionEExample: \"PRODUCE_MODELS=2,SAT_SOLVER=kissat\".")
        private String furtherOptions = "";

        protected SatSolver getSatSolver() {
            return this.satSolver;
        }

        protected String getFurtherOptions() {
            return this.furtherOptions;
        }

        BitwuzlaSettings(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }

        static enum SatSolver {
            LINGELING,
            CMS,
            CADICAL,
            KISSAT;

        }
    }
}

