/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaDeclaration;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaCreator;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Kind;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.RoundingMode;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Sort;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Term;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.TermManager;

public class BitwuzlaFloatingPointManager
extends AbstractFloatingPointFormulaManager<Term, Sort, Void, BitwuzlaDeclaration> {
    private final BitwuzlaFormulaCreator bitwuzlaCreator;
    private final TermManager termManager;
    private final Term roundingMode;

    protected BitwuzlaFloatingPointManager(BitwuzlaFormulaCreator pCreator, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        super(pCreator);
        this.bitwuzlaCreator = pCreator;
        this.termManager = pCreator.getTermManager();
        this.roundingMode = this.getRoundingModeImpl(pFloatingPointRoundingMode);
    }

    @Override
    protected Term getDefaultRoundingMode() {
        return this.roundingMode;
    }

    @Override
    protected Term getRoundingModeImpl(FloatingPointRoundingMode pFloatingPointRoundingMode) {
        switch (pFloatingPointRoundingMode) {
            case NEAREST_TIES_TO_EVEN: {
                return this.termManager.mk_rm_value(RoundingMode.RNE);
            }
            case NEAREST_TIES_AWAY: {
                return this.termManager.mk_rm_value(RoundingMode.RNA);
            }
            case TOWARD_POSITIVE: {
                return this.termManager.mk_rm_value(RoundingMode.RTP);
            }
            case TOWARD_NEGATIVE: {
                return this.termManager.mk_rm_value(RoundingMode.RTN);
            }
            case TOWARD_ZERO: {
                return this.termManager.mk_rm_value(RoundingMode.RTZ);
            }
        }
        throw new AssertionError((Object)"Unexpected value for Floating-Point rounding mode.");
    }

    @Override
    public FloatingPointFormula makeNumber(Rational n, FormulaType.FloatingPointType type) {
        BigDecimal num = new BigDecimal(n.getNum());
        BigDecimal den = new BigDecimal(n.getDen());
        return this.makeNumber(num.divide(den), type);
    }

    @Override
    protected Term makeNumberImpl(double n, FormulaType.FloatingPointType type, Term pFloatingPointRoundingMode) {
        return this.makeNumberImpl(String.valueOf(n), type, pFloatingPointRoundingMode);
    }

    @Override
    protected Term makeNumberImpl(BigInteger exponent, BigInteger mantissa, boolean signBit, FormulaType.FloatingPointType type) {
        Sort signSort = this.termManager.mk_bv_sort(1);
        Term signTerm = this.termManager.mk_bv_value(signSort, signBit ? "1" : "0");
        Sort expSort = this.termManager.mk_bv_sort(type.getExponentSize());
        Term expTerm = this.termManager.mk_bv_value(expSort, exponent.toString(2));
        Sort mantissaSort = this.termManager.mk_bv_sort(type.getMantissaSize());
        Term mantissaTerm = this.termManager.mk_bv_value(mantissaSort, mantissa.toString(2));
        return this.termManager.mk_fp_value(signTerm, expTerm, mantissaTerm);
    }

    private Sort mkFpaSort(FormulaType.FloatingPointType pType) {
        return (Sort)this.getFormulaCreator().getFloatingPointType(pType);
    }

    @Override
    protected Term makeNumberAndRound(String pN, FormulaType.FloatingPointType pType, Term pFloatingPointRoundingMode) {
        Object canonical = pN.replaceAll("(\\.[0-9]+?)0*$", "$1");
        if (!((String)canonical).contains(".")) {
            canonical = (String)canonical + ".0";
        }
        switch (canonical) {
            case "-inf": {
                return this.termManager.mk_fp_neg_inf(this.mkFpaSort(pType));
            }
            case "-0.0": {
                return this.termManager.mk_fp_neg_zero(this.mkFpaSort(pType));
            }
            case "nan": {
                return this.termManager.mk_fp_nan(this.mkFpaSort(pType));
            }
            case "inf": {
                return this.termManager.mk_fp_pos_inf(this.mkFpaSort(pType));
            }
        }
        String decimalString = new BigDecimal((String)canonical).toPlainString();
        return this.termManager.mk_fp_value(this.mkFpaSort(pType), pFloatingPointRoundingMode, decimalString);
    }

    @Override
    protected Term makeVariableImpl(String pVar, FormulaType.FloatingPointType pType) {
        return (Term)this.getFormulaCreator().makeVariable(this.mkFpaSort(pType), pVar);
    }

    @Override
    protected Term makePlusInfinityImpl(FormulaType.FloatingPointType pType) {
        return this.termManager.mk_fp_pos_inf(this.mkFpaSort(pType));
    }

    @Override
    protected Term makeMinusInfinityImpl(FormulaType.FloatingPointType pType) {
        return this.termManager.mk_fp_neg_inf(this.mkFpaSort(pType));
    }

    @Override
    protected Term makeNaNImpl(FormulaType.FloatingPointType pType) {
        return this.termManager.mk_fp_nan(this.mkFpaSort(pType));
    }

    @Override
    protected Term castToImpl(Term pNumber, boolean pSigned, FormulaType<?> pTargetType, Term pRoundingMode) {
        if (pTargetType.isFloatingPointType()) {
            FormulaType.FloatingPointType targetType = (FormulaType.FloatingPointType)pTargetType;
            return this.termManager.mk_term(Kind.FP_TO_FP_FROM_FP, pRoundingMode, pNumber, targetType.getExponentSize(), targetType.getMantissaSize() + 1);
        }
        if (pTargetType.isBitvectorType()) {
            FormulaType.BitvectorType targetType = (FormulaType.BitvectorType)pTargetType;
            if (pSigned) {
                return this.termManager.mk_term(Kind.FP_TO_SBV, pRoundingMode, pNumber, targetType.getSize());
            }
            return this.termManager.mk_term(Kind.FP_TO_UBV, pRoundingMode, pNumber, targetType.getSize());
        }
        throw new UnsupportedOperationException("Attempted cast of FP to an unsupported type: " + pTargetType + ".");
    }

    @Override
    protected Term castFromImpl(Term pNumber, boolean pSigned, FormulaType.FloatingPointType pTargetType, Term pRoundingMode) {
        FormulaType<?> formulaType = this.getFormulaCreator().getFormulaType(pNumber);
        if (formulaType.isFloatingPointType()) {
            return this.castToImpl(pNumber, pSigned, (FormulaType<?>)pTargetType, pRoundingMode);
        }
        if (formulaType.isBitvectorType()) {
            if (pSigned) {
                return this.termManager.mk_term(Kind.FP_TO_FP_FROM_SBV, this.roundingMode, pNumber, pTargetType.getExponentSize(), pTargetType.getMantissaSize() + 1);
            }
            return this.termManager.mk_term(Kind.FP_TO_FP_FROM_UBV, this.roundingMode, pNumber, pTargetType.getExponentSize(), pTargetType.getMantissaSize() + 1);
        }
        throw new UnsupportedOperationException("Attempted cast towards FP from an unsupported type: " + formulaType + ".");
    }

    @Override
    protected Term fromIeeeBitvectorImpl(Term pNumber, FormulaType.FloatingPointType pTargetType) {
        return this.termManager.mk_term(Kind.FP_TO_FP_FROM_BV, pNumber, pTargetType.getExponentSize(), pTargetType.getMantissaSize() + 1);
    }

    @Override
    protected Term toIeeeBitvectorImpl(Term pNumber) {
        int sizeExp = pNumber.sort().fp_exp_size();
        int sizeSig = pNumber.sort().fp_sig_size();
        Sort bvSort = this.termManager.mk_bv_sort(sizeExp + sizeSig);
        Term bvNaN = this.termManager.mk_bv_value(bvSort, "0" + "1".repeat(sizeExp + 1) + "0".repeat(sizeSig - 2));
        Term bvVar = this.termManager.mk_const(bvSort, pNumber.symbol() + "_toIeeeBitvector");
        Term equal = this.termManager.mk_term(Kind.ITE, this.termManager.mk_term(Kind.FP_IS_NAN, pNumber), this.termManager.mk_term(Kind.EQUAL, bvVar, bvNaN), this.termManager.mk_term(Kind.EQUAL, this.termManager.mk_term(Kind.FP_TO_FP_FROM_BV, bvVar, sizeExp, sizeSig), pNumber));
        this.bitwuzlaCreator.addVariableCast(equal);
        return bvVar;
    }

    @Override
    protected Term negate(Term pParam1) {
        return this.termManager.mk_term(Kind.FP_NEG, pParam1);
    }

    @Override
    protected Term abs(Term pParam1) {
        return this.termManager.mk_term(Kind.FP_ABS, pParam1);
    }

    @Override
    protected Term max(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.FP_MAX, pParam1, pParam2);
    }

    @Override
    protected Term min(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.FP_MIN, pParam1, pParam2);
    }

    @Override
    protected Term sqrt(Term pNumber, Term pRoundingMode) {
        return this.termManager.mk_term(Kind.FP_SQRT, pRoundingMode, pNumber);
    }

    @Override
    protected Term add(Term pParam1, Term pParam2, Term pRoundingMode) {
        return this.termManager.mk_term(Kind.FP_ADD, pRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Term subtract(Term pParam1, Term pParam2, Term pFloatingPointRoundingMode) {
        return this.termManager.mk_term(Kind.FP_SUB, pFloatingPointRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Term divide(Term pParam1, Term pParam2, Term pFloatingPointRoundingMode) {
        return this.termManager.mk_term(Kind.FP_DIV, pFloatingPointRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Term multiply(Term pParam1, Term pParam2, Term pFloatingPointRoundingMode) {
        return this.termManager.mk_term(Kind.FP_MUL, pFloatingPointRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Term remainder(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.FP_REM, pParam1, pParam2);
    }

    @Override
    protected Term assignment(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.EQUAL, pParam1, pParam2);
    }

    @Override
    protected Term equalWithFPSemantics(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.FP_EQUAL, pParam1, pParam2);
    }

    @Override
    protected Term greaterThan(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.FP_GT, pParam1, pParam2);
    }

    @Override
    protected Term greaterOrEquals(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.FP_GEQ, pParam1, pParam2);
    }

    @Override
    protected Term lessThan(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.FP_LT, pParam1, pParam2);
    }

    @Override
    protected Term lessOrEquals(Term pParam1, Term pParam2) {
        return this.termManager.mk_term(Kind.FP_LEQ, pParam1, pParam2);
    }

    @Override
    protected Term isNaN(Term pParam) {
        return this.termManager.mk_term(Kind.FP_IS_NAN, pParam);
    }

    @Override
    protected Term isInfinity(Term pParam) {
        return this.termManager.mk_term(Kind.FP_IS_INF, pParam);
    }

    @Override
    protected Term isZero(Term pParam) {
        return this.termManager.mk_term(Kind.FP_IS_ZERO, pParam);
    }

    @Override
    protected Term isSubnormal(Term pParam) {
        return this.termManager.mk_term(Kind.FP_IS_SUBNORMAL, pParam);
    }

    @Override
    protected Term isNormal(Term pParam) {
        return this.termManager.mk_term(Kind.FP_IS_NORMAL, pParam);
    }

    @Override
    protected Term isNegative(Term pParam) {
        return this.termManager.mk_term(Kind.FP_IS_NEG, pParam);
    }

    @Override
    protected Term round(Term pFormula, FloatingPointRoundingMode pRoundingMode) {
        Term rm = this.getRoundingModeImpl(pRoundingMode);
        return this.termManager.mk_term(Kind.FP_RTI, rm, pFormula);
    }
}

