/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.bitwuzla;

import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaDeclaration;
import org.sosy_lab.java_smt.solvers.bitwuzla.BitwuzlaFormulaCreator;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Kind;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Sort;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.Term;
import org.sosy_lab.java_smt.solvers.bitwuzla.api.TermManager;

public class BitwuzlaArrayFormulaManager
extends AbstractArrayFormulaManager<Term, Sort, Void, BitwuzlaDeclaration> {
    private final TermManager termManager;

    protected BitwuzlaArrayFormulaManager(BitwuzlaFormulaCreator pCreator) {
        super(pCreator);
        this.termManager = pCreator.getTermManager();
    }

    @Override
    protected Term select(Term pArray, Term pIndex) {
        return this.termManager.mk_term(Kind.ARRAY_SELECT, pArray, pIndex);
    }

    @Override
    protected Term store(Term pArray, Term pIndex, Term pValue) {
        return this.termManager.mk_term(Kind.ARRAY_STORE, pArray, pIndex, pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Term internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        FormulaType.ArrayFormulaType<TI, TE> arrayFormulaType = FormulaType.getArrayType(pIndexType, pElementType);
        Sort bitwuzlaArrayType = (Sort)this.toSolverType(arrayFormulaType);
        return (Term)this.getFormulaCreator().makeVariable(bitwuzlaArrayType, pName);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Term internalMakeArray(FormulaType<TI> pIndexType, FormulaType<TE> pElementType, Term elseElem) {
        FormulaType.ArrayFormulaType<TI, TE> arrayFormulaType = FormulaType.getArrayType(pIndexType, pElementType);
        Sort bitwuzlaArrayType = (Sort)this.toSolverType(arrayFormulaType);
        return this.termManager.mk_const_array(bitwuzlaArrayType, elseElem);
    }

    @Override
    protected Term equivalence(Term pArray1, Term pArray2) {
        return this.termManager.mk_term(Kind.EQUAL, pArray1, pArray2);
    }
}

