/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class ArraySum {
    public static final int SIZE = 11;

    public static void main(String ... args) throws InvalidConfigurationException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.Z3;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
             ProverEnvironment prover = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            long start = System.currentTimeMillis();
            ArraySolver arraySolver = new ArraySolver(context, prover);
            int i = 0;
            while (arraySolver.hasNext()) {
                System.out.println("#" + ++i + ":");
                System.out.println(arraySolver.next());
            }
            long end = System.currentTimeMillis();
            System.out.println("    Time to solve: " + (end - start) + " ms");
        }
        catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
            logger.logUserException(Level.INFO, e, "Solver " + solver + " is not available.");
        }
        catch (UnsupportedOperationException e) {
            logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
        }
    }

    private ArraySum() {
    }

    public static class ArraySolver
    implements Iterator<String> {
        final ProverEnvironment prover;
        final BooleanFormulaManager bmgr;
        final IntegerFormulaManager imgr;
        final NumeralFormula.IntegerFormula[] symbols;

        private ArraySolver(SolverContext pContext, ProverEnvironment pProver) throws InterruptedException {
            this.prover = pProver;
            this.bmgr = pContext.getFormulaManager().getBooleanFormulaManager();
            this.imgr = pContext.getFormulaManager().getIntegerFormulaManager();
            this.symbols = this.getSymbols();
            this.prover.push(this.bmgr.and(this.getRules()));
            this.prover.push(this.bmgr.and(this.getConnections()));
            this.prover.push(this.imgr.lessThan(this.symbols[0], this.symbols[10]));
        }

        NumeralFormula.IntegerFormula[] getSymbols() {
            NumeralFormula.IntegerFormula[] newSymbols = new NumeralFormula.IntegerFormula[11];
            for (int i = 0; i < 11; ++i) {
                newSymbols[i] = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x_" + i);
            }
            return newSymbols;
        }

        List<BooleanFormula> getRules() {
            ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
            NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
            NumeralFormula.IntegerFormula size = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(11L);
            for (int i = 0; i < 11; ++i) {
                rules.add(this.imgr.lessOrEquals(one, this.symbols[i]));
                rules.add(this.imgr.lessOrEquals(this.symbols[i], size));
            }
            rules.add(this.imgr.distinct(List.of(this.symbols)));
            return rules;
        }

        List<BooleanFormula> getConnections() {
            ArrayList<BooleanFormula> connections = new ArrayList<BooleanFormula>();
            for (int i = 1; i < 11; i += 2) {
                connections.add(this.imgr.equal(this.symbols[i], (NumeralFormula.IntegerFormula)this.imgr.add(this.symbols[i - 1], this.symbols[i + 1])));
            }
            return connections;
        }

        Integer[] getValues() throws SolverException {
            Integer[] solution = new Integer[11];
            try (Model model = this.prover.getModel();){
                for (int i = 0; i < 11; ++i) {
                    solution[i] = Objects.requireNonNull(model.evaluate(this.symbols[i])).intValue();
                }
            }
            return solution;
        }

        @Override
        public boolean hasNext() {
            try {
                boolean isUnsolvable = this.prover.isUnsat();
                return !isUnsolvable;
            }
            catch (InterruptedException | SolverException pE) {
                return false;
            }
        }

        @Override
        public String next() {
            try {
                boolean isUnsolvable = this.prover.isUnsat();
                Preconditions.checkState((!isUnsolvable ? 1 : 0) != 0);
                Integer[] solution = this.getValues();
                ArrayList<BooleanFormula> modelAssignments = new ArrayList<BooleanFormula>();
                for (int i = 0; i < 11; ++i) {
                    modelAssignments.add(this.imgr.equal(this.symbols[i], (NumeralFormula.IntegerFormula)this.imgr.makeNumber(solution[i].intValue())));
                }
                this.prover.push(this.bmgr.not(this.bmgr.and(modelAssignments)));
                return this.toString(solution);
            }
            catch (InterruptedException | SolverException pE) {
                return null;
            }
        }

        private String toString(Integer[] solution) {
            int i;
            StringBuilder str = new StringBuilder();
            for (i = 0; i < 11; i += 2) {
                str.append(Strings.padEnd((String)solution[i].toString(), (int)6, (char)' '));
            }
            str.append('\n');
            for (i = 1; i < 11; i += 2) {
                str.append("   ").append(Strings.padEnd((String)solution[i].toString(), (int)3, (char)' '));
            }
            str.append('\n');
            return str.toString();
        }
    }
}

