/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingInterpolatingProverEnvironment;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingOptimizationProverEnvironment;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingProverEnvironment;

public class DebuggingSolverContext
implements SolverContext {
    private final SolverContext delegate;
    private final DebuggingAssertions debugging;

    public DebuggingSolverContext(SolverContextFactory.Solvers pSolver, Configuration pConfiguration, SolverContext pDelegate) throws InvalidConfigurationException {
        this.delegate = (SolverContext)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = new DebuggingAssertions(pSolver, pConfiguration, pDelegate.getFormulaManager());
    }

    @Override
    public FormulaManager getFormulaManager() {
        this.debugging.assertThreadLocal();
        return new DebuggingFormulaManager(this.delegate.getFormulaManager(), this.debugging);
    }

    @Override
    public ProverEnvironment newProverEnvironment(SolverContext.ProverOptions ... options) {
        this.debugging.assertThreadLocal();
        return new DebuggingProverEnvironment(this.delegate.newProverEnvironment(options), this.debugging);
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation(SolverContext.ProverOptions ... options) {
        this.debugging.assertThreadLocal();
        return new DebuggingInterpolatingProverEnvironment(this.delegate.newProverEnvironmentWithInterpolation(options), this.debugging);
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment(SolverContext.ProverOptions ... options) {
        this.debugging.assertThreadLocal();
        return new DebuggingOptimizationProverEnvironment(this.delegate.newOptimizationProverEnvironment(options), this.debugging);
    }

    @Override
    public String getVersion() {
        this.debugging.assertThreadLocal();
        return this.delegate.getVersion();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        this.debugging.assertThreadLocal();
        return this.delegate.getSolverName();
    }

    @Override
    public ImmutableMap<String, String> getStatistics() {
        this.debugging.assertThreadLocal();
        return this.delegate.getStatistics();
    }

    @Override
    public void close() {
        this.debugging.assertThreadLocal();
        this.delegate.close();
    }
}

