/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.SLFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingSLFormulaManager
implements SLFormulaManager {
    private final SLFormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingSLFormulaManager(SLFormulaManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (SLFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public BooleanFormula makeStar(BooleanFormula f1, BooleanFormula f2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f1);
        this.debugging.assertFormulaInContext(f2);
        BooleanFormula result = this.delegate.makeStar(f1, f2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <AF extends Formula, VF extends Formula> BooleanFormula makePointsTo(AF ptr, VF to) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(ptr);
        this.debugging.assertFormulaInContext(to);
        BooleanFormula result = this.delegate.makePointsTo(ptr, to);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula makeMagicWand(BooleanFormula f1, BooleanFormula f2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(f1);
        this.debugging.assertFormulaInContext(f2);
        BooleanFormula result = this.delegate.makeMagicWand(f1, f2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <AF extends Formula, VF extends Formula, AT extends FormulaType<AF>, VT extends FormulaType<VF>> BooleanFormula makeEmptyHeap(AT pAdressType, VT pValueType) {
        this.debugging.assertThreadLocal();
        BooleanFormula result = this.delegate.makeEmptyHeap(pAdressType, pValueType);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <AF extends Formula, AT extends FormulaType<AF>> AF makeNilElement(AT pAdressType) {
        this.debugging.assertThreadLocal();
        Object result = this.delegate.makeNilElement(pAdressType);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }
}

