/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingBitvectorFormulaManager
implements BitvectorFormulaManager {
    private final BitvectorFormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingBitvectorFormulaManager(BitvectorFormulaManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (BitvectorFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public BitvectorFormula makeBitvector(int length, long pI) {
        this.debugging.assertThreadLocal();
        BitvectorFormula result = this.delegate.makeBitvector(length, pI);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula makeBitvector(int length, BigInteger pI) {
        this.debugging.assertThreadLocal();
        BitvectorFormula result = this.delegate.makeBitvector(length, pI);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula makeBitvector(int length, NumeralFormula.IntegerFormula pI) {
        this.debugging.assertThreadLocal();
        BitvectorFormula result = this.delegate.makeBitvector(length, pI);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public NumeralFormula.IntegerFormula toIntegerFormula(BitvectorFormula pI, boolean signed) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pI);
        NumeralFormula.IntegerFormula result = this.delegate.toIntegerFormula(pI, signed);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula makeVariable(int length, String pVar) {
        this.debugging.assertThreadLocal();
        BitvectorFormula result = this.delegate.makeVariable(length, pVar);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula makeVariable(FormulaType.BitvectorType type, String pVar) {
        this.debugging.assertThreadLocal();
        BitvectorFormula result = this.delegate.makeVariable(type, pVar);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public int getLength(BitvectorFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        return this.delegate.getLength(number);
    }

    @Override
    public BitvectorFormula negate(BitvectorFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BitvectorFormula result = this.delegate.negate(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula add(BitvectorFormula number1, BitvectorFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BitvectorFormula result = this.delegate.add(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula subtract(BitvectorFormula number1, BitvectorFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BitvectorFormula result = this.delegate.subtract(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula divide(BitvectorFormula numerator, BitvectorFormula denumerator, boolean signed) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(numerator);
        this.debugging.assertFormulaInContext(denumerator);
        BitvectorFormula result = this.delegate.divide(numerator, denumerator, signed);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula smodulo(BitvectorFormula numerator, BitvectorFormula denumerator) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(numerator);
        this.debugging.assertFormulaInContext(denumerator);
        BitvectorFormula result = this.delegate.smodulo(numerator, denumerator);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula remainder(BitvectorFormula numerator, BitvectorFormula denumerator, boolean signed) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(numerator);
        this.debugging.assertFormulaInContext(denumerator);
        BitvectorFormula result = this.delegate.remainder(numerator, denumerator, signed);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula multiply(BitvectorFormula number1, BitvectorFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BitvectorFormula result = this.delegate.multiply(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula equal(BitvectorFormula number1, BitvectorFormula number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.equal(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula greaterThan(BitvectorFormula number1, BitvectorFormula number2, boolean signed) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.greaterThan(number1, number2, signed);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula greaterOrEquals(BitvectorFormula number1, BitvectorFormula number2, boolean signed) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.greaterOrEquals(number1, number2, signed);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula lessThan(BitvectorFormula number1, BitvectorFormula number2, boolean signed) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.lessThan(number1, number2, signed);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula lessOrEquals(BitvectorFormula number1, BitvectorFormula number2, boolean signed) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.lessOrEquals(number1, number2, signed);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula not(BitvectorFormula bits) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(bits);
        BitvectorFormula result = this.delegate.not(bits);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula and(BitvectorFormula bits1, BitvectorFormula bits2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(bits1);
        this.debugging.assertFormulaInContext(bits2);
        BitvectorFormula result = this.delegate.and(bits1, bits2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula or(BitvectorFormula bits1, BitvectorFormula bits2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(bits1);
        this.debugging.assertFormulaInContext(bits2);
        BitvectorFormula result = this.delegate.or(bits1, bits2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula xor(BitvectorFormula bits1, BitvectorFormula bits2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(bits1);
        this.debugging.assertFormulaInContext(bits2);
        BitvectorFormula result = this.delegate.xor(bits1, bits2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula shiftRight(BitvectorFormula number, BitvectorFormula toShift, boolean signed) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        this.debugging.assertFormulaInContext(toShift);
        BitvectorFormula result = this.delegate.shiftRight(number, toShift, signed);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula shiftLeft(BitvectorFormula number, BitvectorFormula toShift) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        this.debugging.assertFormulaInContext(toShift);
        BitvectorFormula result = this.delegate.shiftLeft(number, toShift);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula rotateLeft(BitvectorFormula number, int toRotate) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BitvectorFormula result = this.delegate.rotateLeft(number, toRotate);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula rotateLeft(BitvectorFormula number, BitvectorFormula toRotate) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        this.debugging.assertFormulaInContext(toRotate);
        BitvectorFormula result = this.delegate.rotateLeft(number, toRotate);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula rotateRight(BitvectorFormula number, int toRotate) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BitvectorFormula result = this.delegate.rotateRight(number, toRotate);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula rotateRight(BitvectorFormula number, BitvectorFormula toRotate) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        this.debugging.assertFormulaInContext(toRotate);
        BitvectorFormula result = this.delegate.rotateRight(number, toRotate);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula concat(BitvectorFormula prefix, BitvectorFormula suffix) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(prefix);
        this.debugging.assertFormulaInContext(suffix);
        BitvectorFormula result = this.delegate.concat(prefix, suffix);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula extract(BitvectorFormula number, int msb, int lsb) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BitvectorFormula result = this.delegate.extract(number, msb, lsb);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BitvectorFormula extend(BitvectorFormula number, int extensionBits, boolean signed) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        BitvectorFormula result = this.delegate.extend(number, extensionBits, signed);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula distinct(List<BitvectorFormula> pBits) {
        this.debugging.assertThreadLocal();
        for (BitvectorFormula t : pBits) {
            this.debugging.assertFormulaInContext(t);
        }
        BooleanFormula result = this.delegate.distinct(pBits);
        this.debugging.addFormulaTerm(result);
        return result;
    }
}

