/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingArrayFormulaManager
implements ArrayFormulaManager {
    private final ArrayFormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingArrayFormulaManager(ArrayFormulaManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (ArrayFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public <TI extends Formula, TE extends Formula> TE select(ArrayFormula<TI, TE> pArray, TI pIndex) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pArray);
        this.debugging.assertFormulaInContext(pIndex);
        TE result = this.delegate.select(pArray, pIndex);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> store(ArrayFormula<TI, TE> pArray, TI pIndex, TE pValue) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pArray);
        this.debugging.assertFormulaInContext(pIndex);
        this.debugging.assertFormulaInContext(pValue);
        ArrayFormula<TI, TE> result = this.delegate.store(pArray, pIndex, pValue);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <TI extends Formula, TE extends Formula, FTI extends FormulaType<TI>, FTE extends FormulaType<TE>> ArrayFormula<TI, TE> makeArray(String pName, FTI pIndexType, FTE pElementType) {
        this.debugging.assertThreadLocal();
        ArrayFormula result = this.delegate.makeArray(pName, pIndexType, pElementType);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> makeArray(String pName, FormulaType.ArrayFormulaType<TI, TE> type) {
        this.debugging.assertThreadLocal();
        ArrayFormula<TI, TE> result = this.delegate.makeArray(pName, type);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <TI extends Formula, TE extends Formula, FTI extends FormulaType<TI>, FTE extends FormulaType<TE>> ArrayFormula<TI, TE> makeArray(FTI pIndexType, FTE pElementType, TE elseElem) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(elseElem);
        ArrayFormula result = this.delegate.makeArray(pIndexType, pElementType, elseElem);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <TI extends Formula, TE extends Formula> BooleanFormula equivalence(ArrayFormula<TI, TE> pArray1, ArrayFormula<TI, TE> pArray2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pArray1);
        this.debugging.assertFormulaInContext(pArray2);
        BooleanFormula result = this.delegate.equivalence(pArray1, pArray2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public <TI extends Formula> FormulaType<TI> getIndexType(ArrayFormula<TI, ?> pArray) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pArray);
        return this.delegate.getIndexType(pArray);
    }

    @Override
    public <TE extends Formula> FormulaType<TE> getElementType(ArrayFormula<?, TE> pArray) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(pArray);
        return this.delegate.getElementType(pArray);
    }
}

