/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.PropagatorBackend;
import org.sosy_lab.java_smt.api.UserPropagator;

public abstract class AbstractUserPropagator
implements UserPropagator {
    private @Nullable PropagatorBackend backend;

    protected PropagatorBackend getBackend() {
        return (PropagatorBackend)Preconditions.checkNotNull((Object)this.backend, (Object)"Trying to access an uninitialized user propagator.");
    }

    @Override
    public void onPush() {
    }

    @Override
    public void onPop(int numPoppedLevels) {
    }

    @Override
    public void onFinalCheck() {
    }

    @Override
    public void onKnownValue(BooleanFormula expr, boolean value) {
    }

    @Override
    public void onDecision(BooleanFormula expr, boolean value) {
    }

    @Override
    public void initializeWithBackend(PropagatorBackend pBackend) {
        Preconditions.checkState((this.backend == null ? 1 : 0) != 0, (Object)"Trying to register a user propagator that has been registered before.");
        this.backend = (PropagatorBackend)Preconditions.checkNotNull((Object)pBackend);
    }

    @Override
    public void registerExpression(BooleanFormula theoryExpr) {
        Preconditions.checkState((this.backend != null ? 1 : 0) != 0, (Object)"Uninitialized backend. Make sure to register the user propagator with the proverbefore calling this method.");
        this.backend.registerExpression(theoryExpr);
    }
}

