/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public abstract class AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
implements BitvectorFormulaManager {
    private final AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> bmgr;

    protected AbstractBitvectorFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> pCreator, AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> pBmgr) {
        super(pCreator);
        this.bmgr = pBmgr;
    }

    private BitvectorFormula wrap(TFormulaInfo pTerm) {
        return this.getFormulaCreator().encapsulateBitvector(pTerm);
    }

    private void checkSameSize(BitvectorFormula pNumber1, BitvectorFormula pNumber2, String operation) {
        int len2;
        int len1 = this.getLength(pNumber1);
        Preconditions.checkArgument((len1 == (len2 = this.getLength(pNumber2)) ? 1 : 0) != 0, (String)"Can't %s bitvectors with different sizes (%s and %s)", (Object)operation, (Object)len1, (Object)len2);
    }

    @Override
    public BitvectorFormula makeBitvector(int length, NumeralFormula.IntegerFormula pI) {
        Object param1 = this.extractInfo(pI);
        return this.wrap(this.makeBitvectorImpl(length, param1));
    }

    protected abstract TFormulaInfo makeBitvectorImpl(int var1, TFormulaInfo var2);

    @Override
    public NumeralFormula.IntegerFormula toIntegerFormula(BitvectorFormula pI, boolean signed) {
        Object param1 = this.extractInfo(pI);
        return this.getFormulaCreator().encapsulate(FormulaType.IntegerType, this.toIntegerFormulaImpl(param1, signed));
    }

    protected abstract TFormulaInfo toIntegerFormulaImpl(TFormulaInfo var1, boolean var2);

    @Override
    public BitvectorFormula negate(BitvectorFormula pNumber) {
        Object param1 = this.extractInfo(pNumber);
        return this.wrap(this.negate(param1));
    }

    protected abstract TFormulaInfo negate(TFormulaInfo var1);

    @Override
    public BitvectorFormula add(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        this.checkSameSize(pNumber1, pNumber2, "add");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.add(param1, param2));
    }

    protected abstract TFormulaInfo add(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula subtract(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        this.checkSameSize(pNumber1, pNumber2, "subtract");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.subtract(param1, param2));
    }

    protected abstract TFormulaInfo subtract(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula divide(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        this.checkSameSize(pNumber1, pNumber2, "divide");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.divide(param1, param2, signed));
    }

    protected abstract TFormulaInfo divide(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BitvectorFormula remainder(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        this.checkSameSize(pNumber1, pNumber2, "rem");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.remainder(param1, param2, signed));
    }

    protected abstract TFormulaInfo remainder(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BitvectorFormula smodulo(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        this.checkSameSize(pNumber1, pNumber2, "smod");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.smodulo(param1, param2));
    }

    protected abstract TFormulaInfo smodulo(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula multiply(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        this.checkSameSize(pNumber1, pNumber2, "modulo");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.multiply(param1, param2));
    }

    protected abstract TFormulaInfo multiply(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula equal(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        this.checkSameSize(pNumber1, pNumber2, "compare");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.equal(param1, param2));
    }

    protected abstract TFormulaInfo equal(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula greaterThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        this.checkSameSize(pNumber1, pNumber2, "compare");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.greaterThan(param1, param2, signed));
    }

    protected abstract TFormulaInfo greaterThan(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BooleanFormula greaterOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        this.checkSameSize(pNumber1, pNumber2, "compare");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.greaterOrEquals(param1, param2, signed));
    }

    protected abstract TFormulaInfo greaterOrEquals(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BooleanFormula lessThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        this.checkSameSize(pNumber1, pNumber2, "compare");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.lessThan(param1, param2, signed));
    }

    protected abstract TFormulaInfo lessThan(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BooleanFormula lessOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        this.checkSameSize(pNumber1, pNumber2, "compare");
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.lessOrEquals(param1, param2, signed));
    }

    protected abstract TFormulaInfo lessOrEquals(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BitvectorFormula not(BitvectorFormula pBits) {
        Object param1 = this.extractInfo(pBits);
        return this.wrap(this.not(param1));
    }

    protected abstract TFormulaInfo not(TFormulaInfo var1);

    @Override
    public BitvectorFormula and(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        this.checkSameSize(pBits1, pBits2, "combine");
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.and(param1, param2));
    }

    protected abstract TFormulaInfo and(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula or(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        this.checkSameSize(pBits1, pBits2, "combine");
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.or(param1, param2));
    }

    protected abstract TFormulaInfo or(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula xor(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        this.checkSameSize(pBits1, pBits2, "combine");
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.xor(param1, param2));
    }

    protected abstract TFormulaInfo xor(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula makeBitvector(int pLength, long i) {
        return this.wrap(this.makeBitvectorImpl(pLength, i));
    }

    protected TFormulaInfo makeBitvectorImpl(int pLength, long pI) {
        return this.makeBitvectorImpl(pLength, BigInteger.valueOf(pI));
    }

    @Override
    public BitvectorFormula makeBitvector(int pLength, BigInteger i) {
        return this.wrap(this.makeBitvectorImpl(pLength, i));
    }

    protected abstract TFormulaInfo makeBitvectorImpl(int var1, BigInteger var2);

    protected final BigInteger transformValueToRange(int pLength, BigInteger pI) {
        BigInteger max = BigInteger.valueOf(2L).pow(pLength);
        if (pI.signum() < 0) {
            BigInteger min = BigInteger.valueOf(2L).pow(pLength - 1).negate();
            Preconditions.checkArgument((pI.compareTo(min) >= 0 ? 1 : 0) != 0, (String)"%s is to small for a bitvector with length %s", (Object)pI, (int)pLength);
            pI = pI.add(max);
        } else {
            Preconditions.checkArgument((pI.compareTo(max) < 0 ? 1 : 0) != 0, (String)"%s is to large for a bitvector with length %s", (Object)pI, (int)pLength);
        }
        return pI;
    }

    @Override
    public BitvectorFormula makeVariable(FormulaType.BitvectorType type, String pVar) {
        return this.makeVariable(type.getSize(), pVar);
    }

    @Override
    public BitvectorFormula makeVariable(int pLength, String pVar) {
        AbstractFormulaManager.checkVariableName(pVar);
        return this.wrap(this.makeVariableImpl(pLength, pVar));
    }

    protected abstract TFormulaInfo makeVariableImpl(int var1, String var2);

    @Override
    public BitvectorFormula shiftRight(BitvectorFormula pNumber, BitvectorFormula pToShift, boolean signed) {
        return this.wrap(this.shiftRight(this.extractInfo(pNumber), this.extractInfo(pToShift), signed));
    }

    protected abstract TFormulaInfo shiftRight(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BitvectorFormula shiftLeft(BitvectorFormula pNumber, BitvectorFormula toShift) {
        return this.wrap(this.shiftLeft(this.extractInfo(pNumber), this.extractInfo(toShift)));
    }

    protected abstract TFormulaInfo shiftLeft(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula rotateLeft(BitvectorFormula pNumber, int pToRotate) {
        Preconditions.checkArgument((pToRotate >= 0 ? 1 : 0) != 0, (String)"Can not rotate by a negative number %s.", (int)pToRotate);
        return this.wrap(this.rotateLeftByConstant(this.extractInfo(pNumber), pToRotate));
    }

    protected TFormulaInfo rotateLeftByConstant(TFormulaInfo pNumber, int pToRotate) {
        int length = this.getLength(this.wrap(pNumber));
        int shift = pToRotate % length;
        return this.extract(this.concat(pNumber, pNumber), length - 1 + shift, shift);
    }

    @Override
    public BitvectorFormula rotateLeft(BitvectorFormula pNumber, BitvectorFormula pToRotate) {
        return this.wrap(this.rotateLeft(this.extractInfo(pNumber), this.extractInfo(pToRotate)));
    }

    protected TFormulaInfo rotateLeft(TFormulaInfo pNumber, TFormulaInfo pToRotate) {
        int length = this.getLength(this.wrap(pNumber));
        TFormulaInfo lengthAsBv = this.makeBitvectorImpl(length, length);
        TFormulaInfo toRotateInRange = this.smodulo(pToRotate, lengthAsBv);
        return this.or(this.shiftLeft(pNumber, toRotateInRange), this.shiftRight(pNumber, this.subtract(lengthAsBv, toRotateInRange), false));
    }

    @Override
    public BitvectorFormula rotateRight(BitvectorFormula pNumber, int pToRotate) {
        Preconditions.checkArgument((pToRotate >= 0 ? 1 : 0) != 0, (String)"Can not rotate by a negative number %s.", (int)pToRotate);
        return this.wrap(this.rotateRightByConstant(this.extractInfo(pNumber), pToRotate));
    }

    protected TFormulaInfo rotateRightByConstant(TFormulaInfo pNumber, int pToRotate) {
        int length = this.getLength(this.wrap(pNumber));
        int shift = pToRotate % length;
        return this.extract(this.concat(pNumber, pNumber), 2 * length - 1 - shift, length - shift);
    }

    @Override
    public BitvectorFormula rotateRight(BitvectorFormula pNumber, BitvectorFormula pToRotate) {
        return this.wrap(this.rotateRight(this.extractInfo(pNumber), this.extractInfo(pToRotate)));
    }

    protected TFormulaInfo rotateRight(TFormulaInfo pNumber, TFormulaInfo pToRotate) {
        int length = this.getLength(this.wrap(pNumber));
        TFormulaInfo lengthAsBv = this.makeBitvectorImpl(length, length);
        TFormulaInfo toRotateInRange = this.smodulo(pToRotate, lengthAsBv);
        return this.or(this.shiftRight(pNumber, toRotateInRange, false), this.shiftLeft(pNumber, this.subtract(lengthAsBv, toRotateInRange)));
    }

    @Override
    public final BitvectorFormula concat(BitvectorFormula pNumber, BitvectorFormula pAppend) {
        return this.wrap(this.concat(this.extractInfo(pNumber), this.extractInfo(pAppend)));
    }

    protected abstract TFormulaInfo concat(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public final BitvectorFormula extract(BitvectorFormula pNumber, int pMsb, int pLsb) {
        int bitsize = this.getLength(pNumber);
        Preconditions.checkArgument((0 <= pLsb ? 1 : 0) != 0, (String)"index out of bounds (negative index %s)", (int)pLsb);
        Preconditions.checkArgument((pLsb <= pMsb ? 1 : 0) != 0, (String)"invalid range (lsb %s larger than msb %s)", (int)pLsb, (int)pMsb);
        Preconditions.checkArgument((pMsb < bitsize ? 1 : 0) != 0, (String)"index out of bounds (index %s beyond length %s)", (int)pMsb, (int)bitsize);
        return this.wrap(this.extract(this.extractInfo(pNumber), pMsb, pLsb));
    }

    protected abstract TFormulaInfo extract(TFormulaInfo var1, int var2, int var3);

    @Override
    public final BitvectorFormula extend(BitvectorFormula pNumber, int pExtensionBits, boolean pSigned) {
        Preconditions.checkArgument((0 <= pExtensionBits ? 1 : 0) != 0, (Object)"can not extend a negative number of bits");
        return this.wrap(this.extend(this.extractInfo(pNumber), pExtensionBits, pSigned));
    }

    protected abstract TFormulaInfo extend(TFormulaInfo var1, int var2, boolean var3);

    @Override
    public int getLength(BitvectorFormula pNumber) {
        FormulaType<?> type = this.getFormulaCreator().getFormulaType(pNumber);
        return ((FormulaType.BitvectorType)type).getSize();
    }

    @Override
    public final BooleanFormula distinct(List<BitvectorFormula> pBits) {
        if (pBits.size() <= 1) {
            return this.bmgr.makeTrue();
        }
        if ((long)pBits.size() > 1L << this.getLength(pBits.iterator().next())) {
            return this.bmgr.makeFalse();
        }
        return this.wrapBool(this.distinctImpl(Lists.transform(pBits, this::extractInfo)));
    }

    protected TFormulaInfo distinctImpl(List<TFormulaInfo> pBits) {
        ArrayList<TFormulaInfo> lst = new ArrayList<TFormulaInfo>();
        for (int i = 0; i < pBits.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                lst.add(this.bmgr.not(this.equal(pBits.get(i), pBits.get(j))));
            }
        }
        return this.bmgr.andImpl(lst);
    }
}

