/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.math.BigInteger;
import java.util.BitSet;
import org.sosy_lab.java_smt.api.AutoValue_FloatingPointNumber;

@Immutable
@AutoValue
public abstract class FloatingPointNumber {
    public static final int SINGLE_PRECISION_EXPONENT_SIZE = 8;
    public static final int SINGLE_PRECISION_MANTISSA_SIZE = 23;
    public static final int DOUBLE_PRECISION_EXPONENT_SIZE = 11;
    public static final int DOUBLE_PRECISION_MANTISSA_SIZE = 52;

    public abstract boolean getSign();

    public abstract BigInteger getExponent();

    public abstract BigInteger getMantissa();

    public abstract int getExponentSize();

    public abstract int getMantissaSize();

    public static FloatingPointNumber of(boolean sign, BigInteger exponent, BigInteger mantissa, int exponentSize, int mantissaSize) {
        Preconditions.checkArgument((exponent.bitLength() <= exponentSize ? 1 : 0) != 0);
        Preconditions.checkArgument((mantissa.bitLength() <= mantissaSize ? 1 : 0) != 0);
        Preconditions.checkArgument((exponent.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((mantissa.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0);
        return new AutoValue_FloatingPointNumber(sign, exponent, mantissa, exponentSize, mantissaSize);
    }

    public static FloatingPointNumber of(String bits, int exponentSize, int mantissaSize) {
        Preconditions.checkArgument((0 < exponentSize ? 1 : 0) != 0);
        Preconditions.checkArgument((0 < mantissaSize ? 1 : 0) != 0);
        Preconditions.checkArgument((bits.length() == 1 + exponentSize + mantissaSize ? 1 : 0) != 0, (String)"Bitsize (%s) of floating point numeral does not match the size of sign, exponent and mantissa (%s + %s + %s).", (Object)bits.length(), (Object)1, (Object)exponentSize, (Object)mantissaSize);
        Preconditions.checkArgument((boolean)bits.chars().allMatch(c -> c == 48 || c == 49));
        boolean sign = bits.charAt(0) == '1';
        BigInteger exponent = new BigInteger(bits.substring(1, 1 + exponentSize), 2);
        BigInteger mantissa = new BigInteger(bits.substring(1 + exponentSize, 1 + exponentSize + mantissaSize), 2);
        return FloatingPointNumber.of(sign, exponent, mantissa, exponentSize, mantissaSize);
    }

    private boolean isSinglePrecision() {
        return this.getExponentSize() == 8 && this.getMantissaSize() == 23;
    }

    private boolean isDoublePrecision() {
        return this.getExponentSize() == 11 && this.getMantissaSize() == 52;
    }

    public float floatValue() {
        Preconditions.checkArgument((boolean)this.isSinglePrecision(), (String)"Can not represent floating point number %s as Java-based float value.", (Object)this);
        BitSet bits = this.getBits();
        return Float.intBitsToFloat(bits.isEmpty() ? 0 : (int)bits.toLongArray()[0]);
    }

    public double doubleValue() {
        Preconditions.checkArgument((this.isSinglePrecision() || this.isDoublePrecision() ? 1 : 0) != 0, (String)"Can not represent floating point number %s as Java-based double value.", (Object)this);
        if (this.isSinglePrecision()) {
            return this.floatValue();
        }
        BitSet bits = this.getBits();
        return Double.longBitsToDouble(bits.isEmpty() ? 0L : this.getBits().toLongArray()[0]);
    }

    private BitSet getBits() {
        int i;
        int mantissaSize = this.getMantissaSize();
        int exponentSize = this.getExponentSize();
        BigInteger mantissa = this.getMantissa();
        BigInteger exponent = this.getExponent();
        BitSet bits = new BitSet(1 + exponentSize + mantissaSize);
        if (this.getSign()) {
            bits.set(exponentSize + mantissaSize);
        }
        for (i = 0; i < exponentSize; ++i) {
            bits.set(mantissaSize + i, exponent.testBit(i));
        }
        for (i = 0; i < mantissaSize; ++i) {
            bits.set(i, mantissa.testBit(i));
        }
        return bits;
    }

    public final String toString() {
        int length = 1 + this.getExponentSize() + this.getMantissaSize();
        StringBuilder str = new StringBuilder(length);
        BitSet bits = this.getBits();
        for (int i = 0; i < length; ++i) {
            str.append(bits.get(i) ? (char)'1' : '0');
        }
        return str.reverse().toString();
    }
}

