/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_lbool;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.solvers.z3.Z3AbstractProver;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3SolverException;

class Z3TheoremProver
extends Z3AbstractProver
implements ProverEnvironment {
    private final long z3solver;
    private final ShutdownNotifier.ShutdownRequestListener interruptListener;

    Z3TheoremProver(Z3FormulaCreator creator, Z3FormulaManager pMgr, Set<SolverContext.ProverOptions> pOptions, ImmutableMap<String, Object> pSolverOptions, @Nullable PathCounterTemplate pLogfile, ShutdownNotifier pShutdownNotifier) {
        super(creator, pMgr, pOptions, pLogfile, pShutdownNotifier);
        this.z3solver = Native.mkSolver((long)this.z3context);
        Native.solverIncRef((long)this.z3context, (long)this.z3solver);
        this.interruptListener = reason -> Native.solverInterrupt((long)this.z3context, (long)this.z3solver);
        this.shutdownNotifier.register(this.interruptListener);
        long z3params = Native.mkParams((long)this.z3context);
        Native.paramsIncRef((long)this.z3context, (long)z3params);
        for (Map.Entry entry : pSolverOptions.entrySet()) {
            this.addParameter(z3params, (String)entry.getKey(), entry.getValue());
        }
        Native.solverSetParams((long)this.z3context, (long)this.z3solver, (long)z3params);
        Native.paramsDecRef((long)this.z3context, (long)z3params);
    }

    @Override
    protected void pushImpl() throws InterruptedException {
        this.push0();
        try {
            Native.solverPush((long)this.z3context, (long)this.z3solver);
        }
        catch (Z3Exception exception) {
            throw this.creator.handleZ3Exception(exception);
        }
    }

    @Override
    protected void popImpl() {
        Native.solverPop((long)this.z3context, (long)this.z3solver, (int)1);
        this.pop0();
    }

    @Override
    protected void assertContraint(long constraint) {
        Native.solverAssert((long)this.z3context, (long)this.z3solver, (long)constraint);
    }

    @Override
    protected void assertContraintAndTrack(long constraint, long symbol) {
        Native.solverAssertAndTrack((long)this.z3context, (long)this.z3solver, (long)constraint, (long)symbol);
    }

    @Override
    public boolean isUnsat() throws Z3SolverException, InterruptedException {
        int result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.logSolverStack();
        try {
            result = Native.solverCheck((long)this.z3context, (long)this.z3solver);
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        this.undefinedStatusToException(result);
        return result == Z3_lbool.Z3_L_FALSE.toInt();
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws Z3SolverException, InterruptedException {
        int result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            result = Native.solverCheckAssumptions((long)this.z3context, (long)this.z3solver, (int)assumptions.size(), (long[])assumptions.stream().mapToLong(this.creator::extractInfo).toArray());
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        this.undefinedStatusToException(result);
        return result == Z3_lbool.Z3_L_FALSE.toInt();
    }

    private void undefinedStatusToException(int solverStatus) throws Z3SolverException, InterruptedException {
        if (solverStatus == Z3_lbool.Z3_L_UNDEF.toInt()) {
            String reason;
            this.creator.shutdownNotifier.shutdownIfNecessary();
            switch (reason = Native.solverGetReasonUnknown((long)this.z3context, (long)this.z3solver)) {
                case "canceled": 
                case "interrupted": 
                case "interrupted from keyboard": {
                    throw new InterruptedException(reason);
                }
            }
            throw new Z3SolverException("Solver returned 'unknown' status, reason: " + reason);
        }
    }

    @Override
    protected long getUnsatCore0() {
        return Native.solverGetUnsatCore((long)this.z3context, (long)this.z3solver);
    }

    @Override
    protected long getZ3Model() {
        return Native.solverGetModel((long)this.z3context, (long)this.z3solver);
    }

    @Override
    public int size() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver) == super.size() ? 1 : 0) != 0, (String)"prover-size %s does not match stack-size %s", (int)Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver), (int)super.size());
        return super.size();
    }

    @Override
    protected long getStatistics0() {
        return Native.solverGetStatistics((long)this.z3context, (long)this.z3solver);
    }

    public String toString() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Native.solverToString((long)this.z3context, (long)this.z3solver);
    }

    @Override
    public void close() {
        if (!this.closed) {
            Preconditions.checkArgument((Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver) >= 0 ? 1 : 0) != 0, (Object)"a negative number of scopes is not allowed");
            Native.solverReset((long)this.z3context, (long)this.z3solver);
            Native.solverDecRef((long)this.z3context, (long)this.z3solver);
            this.shutdownNotifier.unregister(this.interruptListener);
        }
        super.close();
    }
}

