/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import java.util.List;
import org.sosy_lab.java_smt.basicimpl.AbstractStringFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;

class Z3StringFormulaManager
extends AbstractStringFormulaManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3StringFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    protected Long makeStringImpl(String pValue) {
        return Native.mkString((long)this.z3context, (String)pValue);
    }

    @Override
    protected Long makeVariableImpl(String varName) {
        long type = (Long)this.getFormulaCreator().getStringType();
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Long equal(Long pParam1, Long pParam2) {
        return Native.mkEq((long)this.z3context, (long)pParam1, (long)pParam2);
    }

    @Override
    protected Long greaterThan(Long pParam1, Long pParam2) {
        return this.lessThan(pParam2, pParam1);
    }

    @Override
    protected Long greaterOrEquals(Long pParam1, Long pParam2) {
        return this.lessOrEquals(pParam2, pParam1);
    }

    @Override
    protected Long lessThan(Long pParam1, Long pParam2) {
        return Native.mkStrLt((long)this.z3context, (long)pParam1, (long)pParam2);
    }

    @Override
    protected Long lessOrEquals(Long pParam1, Long pParam2) {
        return Native.mkStrLe((long)this.z3context, (long)pParam1, (long)pParam2);
    }

    @Override
    protected Long length(Long pParam) {
        return Native.mkSeqLength((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long concatImpl(List<Long> parts) {
        Preconditions.checkArgument((!parts.isEmpty() ? 1 : 0) != 0);
        return Native.mkSeqConcat((long)this.z3context, (int)parts.size(), (long[])Longs.toArray(parts));
    }

    @Override
    protected Long prefix(Long prefix, Long str) {
        return Native.mkSeqPrefix((long)this.z3context, (long)prefix, (long)str);
    }

    @Override
    protected Long suffix(Long suffix, Long str) {
        return Native.mkSeqSuffix((long)this.z3context, (long)suffix, (long)str);
    }

    @Override
    protected Long in(Long str, Long regex) {
        return Native.mkSeqInRe((long)this.z3context, (long)str, (long)regex);
    }

    @Override
    protected Long contains(Long str, Long part) {
        return Native.mkSeqContains((long)this.z3context, (long)str, (long)part);
    }

    @Override
    protected Long indexOf(Long str, Long part, Long startIndex) {
        return Native.mkSeqIndex((long)this.z3context, (long)str, (long)part, (long)startIndex);
    }

    @Override
    protected Long charAt(Long str, Long index) {
        return Native.mkSeqAt((long)this.z3context, (long)str, (long)index);
    }

    @Override
    protected Long substring(Long str, Long index, Long length) {
        return Native.mkSeqExtract((long)this.z3context, (long)str, (long)index, (long)length);
    }

    @Override
    protected Long replace(Long fullStr, Long target, Long replacement) {
        return Native.mkSeqReplace((long)this.z3context, (long)fullStr, (long)target, (long)replacement);
    }

    @Override
    protected Long replaceAll(Long fullStr, Long target, Long replacement) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Long makeRegexImpl(String value) {
        Long str = this.makeStringImpl(value);
        return Native.mkSeqToRe((long)this.z3context, (long)str);
    }

    @Override
    protected Long noneImpl() {
        return Native.mkReEmpty((long)this.z3context, (long)((Long)this.formulaCreator.getRegexType()));
    }

    @Override
    protected Long allImpl() {
        return Native.mkReFull((long)this.z3context, (long)((Long)this.formulaCreator.getRegexType()));
    }

    @Override
    protected Long allCharImpl() {
        return Native.mkReAllchar((long)this.z3context, (long)((Long)this.formulaCreator.getRegexType()));
    }

    @Override
    protected Long range(Long start, Long end) {
        return Native.mkReRange((long)this.z3context, (long)start, (long)end);
    }

    @Override
    protected Long concatRegexImpl(List<Long> parts) {
        if (parts.isEmpty()) {
            return this.noneImpl();
        }
        return Native.mkReConcat((long)this.z3context, (int)parts.size(), (long[])Longs.toArray(parts));
    }

    @Override
    protected Long union(Long pParam1, Long pParam2) {
        return Native.mkReUnion((long)this.z3context, (int)2, (long[])new long[]{pParam1, pParam2});
    }

    @Override
    protected Long intersection(Long pParam1, Long pParam2) {
        return Native.mkReIntersect((long)this.z3context, (int)2, (long[])new long[]{pParam1, pParam2});
    }

    @Override
    protected Long closure(Long pParam) {
        return Native.mkReStar((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long complement(Long pParam) {
        return Native.mkReComplement((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long toIntegerFormula(Long pParam) {
        return Native.mkStrToInt((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long toStringFormula(Long pParam) {
        return Native.mkIntToStr((long)this.z3context, (long)pParam);
    }
}

