/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;

@Immutable
public class OpenSmtFormula
implements Formula {
    private final Logic osmtLogic;
    private final PTRef osmtTerm;

    OpenSmtFormula(Logic logic, PTRef term) {
        this.osmtLogic = logic;
        this.osmtTerm = term;
    }

    @Override
    public final String toString() {
        return this.osmtLogic.pp(this.osmtTerm);
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSmtFormula)) {
            return false;
        }
        OpenSmtFormula that = (OpenSmtFormula)o;
        return this.osmtLogic.equals(that.osmtLogic) && this.osmtTerm.equals((Object)that.osmtTerm);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.osmtLogic, this.osmtTerm);
    }

    final PTRef getOsmtTerm() {
        return this.osmtTerm;
    }

    @Immutable
    static final class OpenSmtBooleanFormula
    extends OpenSmtFormula
    implements BooleanFormula {
        OpenSmtBooleanFormula(Logic pLogic, PTRef pTerm) {
            super(pLogic, pTerm);
        }
    }

    @Immutable
    static final class OpenSmtRationalFormula
    extends OpenSmtFormula
    implements NumeralFormula.RationalFormula {
        OpenSmtRationalFormula(Logic pLogic, PTRef pTerm) {
            super(pLogic, pTerm);
        }
    }

    @Immutable
    static final class OpenSmtIntegerFormula
    extends OpenSmtFormula
    implements NumeralFormula.IntegerFormula {
        OpenSmtIntegerFormula(Logic pLogic, PTRef pTerm) {
            super(pLogic, pTerm);
        }
    }

    @Immutable
    static final class OpenSmtArrayFormula<TI extends Formula, TE extends Formula>
    extends OpenSmtFormula
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        OpenSmtArrayFormula(Logic pLogic, PTRef pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(pLogic, pTerm);
            this.indexType = pIndexType;
            this.elementType = pElementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

