/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingModeFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;

@Immutable(containerOf={"TFormulaInfo"})
abstract class AbstractFormula<TFormulaInfo>
implements Formula {
    private final TFormulaInfo formulaInfo;

    private AbstractFormula(TFormulaInfo formulaInfo) {
        this.formulaInfo = Preconditions.checkNotNull(formulaInfo);
    }

    @Override
    public final boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractFormula)) {
            return false;
        }
        TFormulaInfo otherFormulaInfo = ((AbstractFormula)o).formulaInfo;
        return this.formulaInfo == otherFormulaInfo || this.formulaInfo.equals(otherFormulaInfo);
    }

    final TFormulaInfo getFormulaInfo() {
        return this.formulaInfo;
    }

    @Override
    public final int hashCode() {
        return this.formulaInfo.hashCode();
    }

    @Override
    public final String toString() {
        return this.formulaInfo.toString();
    }

    static final class EnumerationFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements EnumerationFormula {
        EnumerationFormulaImpl(TFormulaInfo pT) {
            super(pT);
        }
    }

    static final class RegexFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements RegexFormula {
        RegexFormulaImpl(TFormulaInfo pT) {
            super(pT);
        }
    }

    static final class StringFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements StringFormula {
        StringFormulaImpl(TFormulaInfo pT) {
            super(pT);
        }
    }

    static final class RationalFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements NumeralFormula.RationalFormula {
        RationalFormulaImpl(TFormulaInfo pTerm) {
            super(pTerm);
        }
    }

    static final class IntegerFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements NumeralFormula.IntegerFormula {
        IntegerFormulaImpl(TFormulaInfo pTerm) {
            super(pTerm);
        }
    }

    static final class BooleanFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements BooleanFormula {
        BooleanFormulaImpl(TFormulaInfo pT) {
            super(pT);
        }
    }

    static final class FloatingPointRoundingModeFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements FloatingPointRoundingModeFormula {
        FloatingPointRoundingModeFormulaImpl(TFormulaInfo info) {
            super(info);
        }
    }

    static final class FloatingPointFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements FloatingPointFormula {
        FloatingPointFormulaImpl(TFormulaInfo info) {
            super(info);
        }
    }

    static final class BitvectorFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements BitvectorFormula {
        BitvectorFormulaImpl(TFormulaInfo info) {
            super(info);
        }
    }

    static final class ArrayFormulaImpl<TI extends Formula, TE extends Formula, TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        ArrayFormulaImpl(TFormulaInfo info, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(info);
            this.indexType = (FormulaType)Preconditions.checkNotNull(pIndexType);
            this.elementType = (FormulaType)Preconditions.checkNotNull(pElementType);
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

