/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.EnumerationFormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public abstract class AbstractEnumerationFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
implements EnumerationFormulaManager {
    protected final Map<String, EnumType> enumerations = new LinkedHashMap<String, EnumType>();

    protected AbstractEnumerationFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> pFormulaCreator) {
        super(pFormulaCreator);
    }

    private EnumerationFormula wrap(TFormulaInfo pTerm) {
        return this.getFormulaCreator().encapsulateEnumeration(pTerm);
    }

    private void checkSameEnumerationType(EnumerationFormula pF1, EnumerationFormula pF2) {
        FormulaType<?> type1 = this.formulaCreator.getFormulaType(pF1);
        FormulaType<?> type2 = this.formulaCreator.getFormulaType(pF2);
        Preconditions.checkArgument((boolean)(type1 instanceof FormulaType.EnumerationFormulaType));
        Preconditions.checkArgument((boolean)(type2 instanceof FormulaType.EnumerationFormulaType));
        Preconditions.checkArgument((boolean)type1.equals(type2), (String)"Can't compare element of type %s with element of type %s.", type1, type2);
    }

    @Override
    public FormulaType.EnumerationFormulaType declareEnumeration(String pName, Set<String> pElementNames) {
        AbstractFormulaManager.checkVariableName(pName);
        return this.declareEnumerationImpl(pName, pElementNames);
    }

    protected FormulaType.EnumerationFormulaType declareEnumerationImpl(String pName, Set<String> pElementNames) {
        FormulaType.EnumerationFormulaType type = FormulaType.getEnumerationType(pName, pElementNames);
        EnumType existingType = this.enumerations.get(pName);
        if (existingType == null) {
            this.enumerations.put(pName, this.declareEnumeration0(type));
        } else {
            Preconditions.checkArgument((boolean)type.equals(existingType.getEnumerationFormulaType()), (String)"Enumeration type '%s' is already declared as '%s'.", (Object)type, (Object)existingType.getEnumerationFormulaType());
        }
        return type;
    }

    protected abstract EnumType declareEnumeration0(FormulaType.EnumerationFormulaType var1);

    @Override
    public EnumerationFormula makeConstant(String pName, FormulaType.EnumerationFormulaType pType) {
        Preconditions.checkArgument((boolean)pType.getElements().contains((Object)pName), (String)"Constant '%s' is not available in the enumeration type '%s'", (Object)pName, (Object)pType);
        return this.wrap(this.makeConstantImpl(pName, pType));
    }

    protected TFormulaInfo makeConstantImpl(String pName, FormulaType.EnumerationFormulaType pType) {
        return (TFormulaInfo)Preconditions.checkNotNull((Object)this.enumerations.get((Object)pType.getName()).constants.get((Object)pName));
    }

    @Override
    public EnumerationFormula makeVariable(String pVar, FormulaType.EnumerationFormulaType pType) {
        AbstractFormulaManager.checkVariableName(pVar);
        return this.wrap(this.makeVariableImpl(pVar, pType));
    }

    protected TFormulaInfo makeVariableImpl(String pVar, FormulaType.EnumerationFormulaType pType) {
        return this.getFormulaCreator().makeVariable(this.enumerations.get((Object)pType.getName()).nativeType, pVar);
    }

    @Override
    public BooleanFormula equivalence(EnumerationFormula pF1, EnumerationFormula pF2) {
        this.checkSameEnumerationType(pF1, pF2);
        return this.wrapBool(this.equivalenceImpl(this.extractInfo(pF1), this.extractInfo(pF2)));
    }

    protected abstract TFormulaInfo equivalenceImpl(TFormulaInfo var1, TFormulaInfo var2);

    protected class EnumType {
        private final FormulaType.EnumerationFormulaType enumerationFormulaType;
        private final TType nativeType;
        private final ImmutableMap<String, TFormulaInfo> constants;

        public EnumType(FormulaType.EnumerationFormulaType pEnumerationFormulaType, TType pNativeType, ImmutableMap<String, TFormulaInfo> pConstants) {
            this.enumerationFormulaType = pEnumerationFormulaType;
            this.nativeType = pNativeType;
            this.constants = pConstants;
        }

        public FormulaType.EnumerationFormulaType getEnumerationFormulaType() {
            return this.enumerationFormulaType;
        }

        public boolean hasConstants(String name) {
            return this.constants.containsKey((Object)name);
        }
    }
}

