/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.EnumerationFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.api.StringFormulaManager;
import org.sosy_lab.java_smt.api.UFManager;
import org.sosy_lab.java_smt.solvers.opensmt.Logics;
import org.sosy_lab.java_smt.test.BooleanFormulaSubject;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="test code")
public abstract class SolverBasedTest0 {
    protected Configuration config;
    protected final LogManager logger = LogManager.createTestLogManager();
    protected SolverContextFactory factory;
    protected SolverContext context;
    protected FormulaManager mgr;
    protected BooleanFormulaManager bmgr;
    protected UFManager fmgr;
    protected IntegerFormulaManager imgr;
    protected @Nullable RationalFormulaManager rmgr;
    protected @Nullable BitvectorFormulaManager bvmgr;
    protected @Nullable QuantifiedFormulaManager qmgr;
    protected @Nullable ArrayFormulaManager amgr;
    protected @Nullable FloatingPointFormulaManager fpmgr;
    protected @Nullable StringFormulaManager smgr;
    protected @Nullable EnumerationFormulaManager emgr;
    protected ShutdownManager shutdownManager = ShutdownManager.create();

    protected ShutdownNotifier shutdownNotifierToUse() {
        return this.shutdownManager.getNotifier();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return SolverContextFactory.Solvers.SMTINTERPOL;
    }

    protected Logics logicToUse() {
        return Logics.QF_AUFLIRA;
    }

    protected ConfigurationBuilder createTestConfigBuilder() {
        ConfigurationBuilder newConfig = Configuration.builder().setOption("solver.solver", this.solverToUse().toString());
        if (this.solverToUse() == SolverContextFactory.Solvers.OPENSMT) {
            newConfig.setOption("solver.opensmt.logic", this.logicToUse().toString());
        }
        return newConfig;
    }

    @Before
    public final void initSolver() throws InvalidConfigurationException {
        this.config = this.createTestConfigBuilder().build();
        this.factory = new SolverContextFactory(this.config, this.logger, this.shutdownNotifierToUse());
        try {
            this.context = this.factory.generateContext();
        }
        catch (InvalidConfigurationException e) {
            TruthJUnit.assume().withMessage(e.getMessage()).that((Throwable)e).hasCauseThat().isNotInstanceOf(UnsatisfiedLinkError.class);
            throw e;
        }
        this.mgr = this.context.getFormulaManager();
        this.fmgr = this.mgr.getUFManager();
        this.bmgr = this.mgr.getBooleanFormulaManager();
        try {
            this.imgr = this.mgr.getIntegerFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.imgr = null;
        }
        try {
            this.rmgr = this.mgr.getRationalFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.rmgr = null;
        }
        try {
            this.bvmgr = this.mgr.getBitvectorFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.bvmgr = null;
        }
        try {
            this.qmgr = this.mgr.getQuantifiedFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.qmgr = null;
        }
        try {
            this.amgr = this.mgr.getArrayFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.amgr = null;
        }
        try {
            this.fpmgr = this.mgr.getFloatingPointFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.fpmgr = null;
        }
        try {
            this.smgr = this.mgr.getStringFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.smgr = null;
        }
        try {
            this.emgr = this.mgr.getEnumerationFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.emgr = null;
        }
    }

    @After
    public final void closeSolver() {
        if (this.context != null) {
            this.context.close();
        }
    }

    protected final void requireIntegers() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of integers", new Object[]{this.solverToUse()}).that((Object)this.imgr).isNotNull();
    }

    protected final void requireRationals() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of rationals", new Object[]{this.solverToUse()}).that((Object)this.rmgr).isNotNull();
    }

    protected final void requireBitvectors() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of bitvectors", new Object[]{this.solverToUse()}).that((Object)this.bvmgr).isNotNull();
    }

    protected final void requireBitvectorToInt() {
        TruthJUnit.assume().withMessage("Solver %s does not yet support the conversion between bitvectors and integers", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.YICES2);
    }

    protected final void requireQuantifiers() {
        TruthJUnit.assume().withMessage("Solver %s does not support quantifiers", new Object[]{this.solverToUse()}).that((Object)this.qmgr).isNotNull();
    }

    protected void requireArrays() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of arrays", new Object[]{this.solverToUse()}).that((Object)this.amgr).isNotNull();
    }

    protected final void requireFloats() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of floats", new Object[]{this.solverToUse()}).that((Object)this.fpmgr).isNotNull();
    }

    protected final void requireStrings() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of strings", new Object[]{this.solverToUse()}).that((Object)this.smgr).isNotNull();
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of arrays", new Object[]{this.solverToUse()}).that((Object)this.amgr).isNotNull();
    }

    protected final void requireEnumeration() {
        TruthJUnit.assume().withMessage("Solver %s does not support the theory of enumerations", new Object[]{this.solverToUse()}).that((Object)this.emgr).isNotNull();
    }

    protected final void requireOptimization() {
        try {
            this.context.newOptimizationProverEnvironment(new SolverContext.ProverOptions[0]).close();
        }
        catch (UnsupportedOperationException e) {
            TruthJUnit.assume().withMessage("Solver %s does not support optimization", new Object[]{this.solverToUse()}).that((Throwable)e).isNull();
        }
    }

    protected final void requireInterpolation() {
        try {
            this.context.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]).close();
        }
        catch (UnsupportedOperationException e) {
            TruthJUnit.assume().withMessage("Solver %s does not support interpolation", new Object[]{this.solverToUse()}).that((Throwable)e).isNull();
        }
    }

    protected void requireParser() {
        TruthJUnit.assume().withMessage("Solver %s does not support parsing formulae", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNoneOf((Object)SolverContextFactory.Solvers.CVC4, (Object)SolverContextFactory.Solvers.BOOLECTOR, new Object[]{SolverContextFactory.Solvers.YICES2, SolverContextFactory.Solvers.CVC5});
    }

    protected void requireArrayModel() {
        TruthJUnit.assume().withMessage("Solver %s does not support model generation for arrays", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.OPENSMT);
    }

    protected void requireModel() {
    }

    protected void requireVisitor() {
        TruthJUnit.assume().withMessage("Solver %s does not support formula visitor", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
    }

    protected void requireUnsatCore() {
        TruthJUnit.assume().withMessage("Solver %s does not support unsat core generation", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNoneOf((Object)SolverContextFactory.Solvers.BOOLECTOR, (Object)SolverContextFactory.Solvers.OPENSMT, new Object[0]);
    }

    protected void requireSubstitution() {
        TruthJUnit.assume().withMessage("Solver %s does not support formula substitution", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
    }

    protected final BooleanFormulaSubject assertThatFormula(BooleanFormula formula) {
        return (BooleanFormulaSubject)BooleanFormulaSubject.assertUsing(this.context).that((Object)formula);
    }

    protected final ProverEnvironmentSubject assertThatEnvironment(BasicProverEnvironment<?> prover) {
        return ProverEnvironmentSubject.assertThat(prover);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void evaluateInModel(BooleanFormula constraint, Formula formula, Collection<Object> possibleExpectedValues, Collection<Formula> possibleExpectedFormulas) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(constraint);
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                if (formula instanceof BooleanFormula) {
                    Truth.assertThat((Boolean)m.evaluate((BooleanFormula)formula)).isIn(possibleExpectedValues);
                    Truth.assertThat((Object)m.evaluate(formula)).isIn(possibleExpectedValues);
                } else if (formula instanceof NumeralFormula.IntegerFormula) {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)formula)).isIn(possibleExpectedValues);
                    Truth.assertThat((Object)m.evaluate(formula)).isIn(possibleExpectedValues);
                } else if (formula instanceof NumeralFormula.RationalFormula) {
                    Truth.assertThat((Comparable)m.evaluate((NumeralFormula.RationalFormula)formula)).isIn(possibleExpectedValues);
                } else if (formula instanceof StringFormula) {
                    Truth.assertThat((String)m.evaluate((StringFormula)formula)).isIn(possibleExpectedValues);
                    Truth.assertThat((Object)m.evaluate(formula)).isIn(possibleExpectedValues);
                } else {
                    Truth.assertThat((Object)m.evaluate(formula)).isIn(possibleExpectedValues);
                }
                Formula eval = m.eval(formula);
                if (eval == null) return;
                switch (this.solverToUse()) {
                    case Z3: {
                        return;
                    }
                    case BOOLECTOR: {
                        return;
                    }
                    default: {
                        Truth.assertThat((Object)eval).isIn(possibleExpectedFormulas);
                        return;
                    }
                }
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static abstract class ParameterizedSolverBasedTest0
    extends SolverBasedTest0 {
        @Parameterized.Parameter(value=0)
        public SolverContextFactory.Solvers solver;

        @Parameterized.Parameters(name="{0}")
        public static Object[] getAllSolvers() {
            return SolverContextFactory.Solvers.values();
        }

        @Override
        protected SolverContextFactory.Solvers solverToUse() {
            return this.solver;
        }
    }
}

