/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.basicimpl.CachingModel;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3Model;
import org.sosy_lab.java_smt.solvers.z3.Z3SolverException;

abstract class Z3AbstractProver
extends AbstractProverWithAllSat<Void> {
    protected final Z3FormulaCreator creator;
    protected final long z3context;
    private final Z3FormulaManager mgr;
    private final UniqueIdGenerator trackId = new UniqueIdGenerator();
    private final @Nullable Deque<PersistentMap<String, BooleanFormula>> storedConstraints;
    private final @Nullable PathCounterTemplate logfile;

    Z3AbstractProver(Z3FormulaCreator pCreator, Z3FormulaManager pMgr, Set<SolverContext.ProverOptions> pOptions, @Nullable PathCounterTemplate pLogfile, ShutdownNotifier pShutdownNotifier) {
        super(pOptions, pMgr.getBooleanFormulaManager(), pShutdownNotifier);
        this.creator = pCreator;
        this.z3context = (Long)this.creator.getEnv();
        if (pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE)) {
            this.storedConstraints = new ArrayDeque<PersistentMap<String, BooleanFormula>>();
            this.storedConstraints.push((PersistentMap<String, BooleanFormula>)PathCopyingPersistentTreeMap.of());
        } else {
            this.storedConstraints = null;
        }
        this.logfile = pLogfile;
        this.mgr = pMgr;
    }

    void addParameter(long z3params, String key, Object value) {
        long keySymbol = Native.mkStringSymbol((long)this.z3context, (String)key);
        if (value instanceof Boolean) {
            Native.paramsSetBool((long)this.z3context, (long)z3params, (long)keySymbol, (boolean)((Boolean)value));
        } else if (value instanceof Integer) {
            Native.paramsSetUint((long)this.z3context, (long)z3params, (long)keySymbol, (int)((Integer)value));
        } else if (value instanceof Double) {
            Native.paramsSetDouble((long)this.z3context, (long)z3params, (long)keySymbol, (double)((Double)value));
        } else if (value instanceof String) {
            long valueSymbol = Native.mkStringSymbol((long)this.z3context, (String)((String)value));
            Native.paramsSetSymbol((long)this.z3context, (long)z3params, (long)keySymbol, (long)valueSymbol);
        } else {
            throw new IllegalArgumentException(String.format("unexpected type '%s' with value '%s' for parameter '%s'", value.getClass(), value, key));
        }
    }

    protected void logSolverStack() throws Z3SolverException {
        if (this.logfile != null) {
            try {
                Path filename = this.logfile.getFreshPath();
                MoreFiles.createParentDirectories((Path)filename, (FileAttribute[])new FileAttribute[0]);
                Files.writeString(filename, (CharSequence)(this + "(check-sat)\n"), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new Z3SolverException("Cannot write Z3 log file: " + e.getMessage());
            }
        }
    }

    @Override
    public Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        return new CachingModel(this.getEvaluatorWithoutChecks());
    }

    @Override
    protected Z3Model getEvaluatorWithoutChecks() {
        return new Z3Model(this, this.z3context, this.getZ3Model(), this.creator);
    }

    protected abstract long getZ3Model();

    protected abstract void assertContraint(long var1);

    protected abstract void assertContraintAndTrack(long var1, long var3);

    @Override
    protected Void addConstraintImpl(BooleanFormula f) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long e = this.creator.extractInfo(f);
        Native.incRef((long)this.z3context, (long)e);
        try {
            if (this.storedConstraints != null) {
                String varName = String.format("Z3_UNSAT_CORE_%d", this.trackId.getFreshId());
                BooleanFormula t = ((AbstractBooleanFormulaManager)this.mgr.getBooleanFormulaManager()).makeVariable(varName);
                this.assertContraintAndTrack(e, this.creator.extractInfo(t));
                this.storedConstraints.push((PersistentMap<String, BooleanFormula>)this.storedConstraints.pop().putAndCopy((Object)varName, (Object)f));
                Native.decRef((long)this.z3context, (long)e);
            } else {
                this.assertContraint(e);
            }
        }
        catch (Z3Exception exception) {
            throw this.creator.handleZ3Exception(exception);
        }
        Native.decRef((long)this.z3context, (long)e);
        return null;
    }

    protected void push0() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.storedConstraints != null) {
            this.storedConstraints.push(this.storedConstraints.peek());
        }
    }

    protected void pop0() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.storedConstraints != null) {
            this.storedConstraints.pop();
        }
    }

    protected abstract long getUnsatCore0();

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        if (this.storedConstraints == null) {
            throw new UnsupportedOperationException("Option to generate the UNSAT core wasn't enabled when creating the prover environment.");
        }
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        long unsatCore = this.getUnsatCore0();
        Native.astVectorIncRef((long)this.z3context, (long)unsatCore);
        for (int i = 0; i < Native.astVectorSize((long)this.z3context, (long)unsatCore); ++i) {
            long ast = Native.astVectorGet((long)this.z3context, (long)unsatCore, (int)i);
            Native.incRef((long)this.z3context, (long)ast);
            String varName = Native.astToString((long)this.z3context, (long)ast);
            Native.decRef((long)this.z3context, (long)ast);
            constraints.add((BooleanFormula)this.storedConstraints.peek().get((Object)varName));
        }
        Native.astVectorDecRef((long)this.z3context, (long)unsatCore);
        return constraints;
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        this.checkGenerateUnsatCoresOverAssumptions();
        if (!this.isUnsatWithAssumptions(assumptions)) {
            return Optional.empty();
        }
        ArrayList<BooleanFormula> core = new ArrayList<BooleanFormula>();
        long unsatCore = this.getUnsatCore0();
        Native.astVectorIncRef((long)this.z3context, (long)unsatCore);
        for (int i = 0; i < Native.astVectorSize((long)this.z3context, (long)unsatCore); ++i) {
            long ast = Native.astVectorGet((long)this.z3context, (long)unsatCore, (int)i);
            core.add(this.creator.encapsulateBoolean(ast));
        }
        Native.astVectorDecRef((long)this.z3context, (long)unsatCore);
        return Optional.of(core);
    }

    protected abstract long getStatistics0();

    @Override
    public ImmutableMap<String, String> getStatistics() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<String> seenKeys = new HashSet<String>();
        long stats = this.getStatistics0();
        for (int i = 0; i < Native.statsSize((long)this.z3context, (long)stats); ++i) {
            String key = this.getUnusedKey(seenKeys, Native.statsGetKey((long)this.z3context, (long)stats, (int)i));
            if (Native.statsIsUint((long)this.z3context, (long)stats, (int)i)) {
                builder.put((Object)key, (Object)Integer.toString(Native.statsGetUintValue((long)this.z3context, (long)stats, (int)i)));
                continue;
            }
            if (Native.statsIsDouble((long)this.z3context, (long)stats, (int)i)) {
                builder.put((Object)key, (Object)Double.toString(Native.statsGetDoubleValue((long)this.z3context, (long)stats, (int)i)));
                continue;
            }
            throw new IllegalStateException(String.format("Unknown data entry value for key %s at position %d in statistics '%s'", key, i, Native.statsToString((long)this.z3context, (long)stats)));
        }
        return builder.buildOrThrow();
    }

    private String getUnusedKey(Set<String> seenKeys, String originalKey) {
        String key;
        if (seenKeys.add(originalKey)) {
            return originalKey;
        }
        int index = 0;
        while (!seenKeys.add(key = originalKey + " (" + ++index + ")")) {
        }
        return key;
    }

    @Override
    public void close() {
        if (!this.closed && this.storedConstraints != null) {
            this.storedConstraints.clear();
        }
        super.close();
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        try {
            return super.allSat(callback, important);
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
    }
}

