/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.basetypes.IdealInt;
import ap.parser.IAtom;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.IIntLit;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import ap.terfor.preds.Predicate;
import ap.theories.nia.GroebnerMultiplication;
import ap.types.Sort;
import ap.types.Sort$;
import ap.types.SortedIFunction$;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import scala.Option;
import scala.collection.immutable.Seq;

abstract class PrincessFunctionDeclaration {
    private PrincessFunctionDeclaration() {
    }

    abstract IExpression makeApp(PrincessEnvironment var1, List<IExpression> var2);

    static class PrincessMultiplyDeclaration
    extends PrincessFunctionDeclaration {
        static final PrincessMultiplyDeclaration INSTANCE = new PrincessMultiplyDeclaration(){};

        private PrincessMultiplyDeclaration() {
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
            return GroebnerMultiplication.mult((ITerm)((ITerm)args.get(0)), (ITerm)((ITerm)args.get(1)));
        }
    }

    static class PrincessEquationDeclaration
    extends PrincessFunctionDeclaration {
        static final PrincessEquationDeclaration INSTANCE = new PrincessEquationDeclaration(){};

        private PrincessEquationDeclaration() {
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
            return ((ITerm)args.get(0)).$eq$eq$eq((ITerm)args.get(1));
        }
    }

    static class PrincessBitvectorToBitvectorDeclaration
    extends AbstractDeclaration<IFunction> {
        PrincessBitvectorToBitvectorDeclaration(IFunction pFunction) {
            super(pFunction);
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            ITerm arg0 = (ITerm)args.get(0);
            Sort sort = Sort$.MODULE$.sortOf(arg0);
            Option<Object> bitWidth = PrincessEnvironment.getBitWidth(sort);
            Preconditions.checkArgument((boolean)bitWidth.isDefined(), (String)"BitvectorFormula with actual type %s: %s", (Object)sort, (Object)arg0);
            int bitsize = (Integer)bitWidth.get();
            ArrayList<Object> newArgs = new ArrayList<Object>();
            newArgs.add(new IIntLit(IdealInt.apply((int)bitsize)));
            for (IExpression arg : args) {
                newArgs.add((ITerm)arg);
            }
            return new IFunApp((IFunction)this.declarationItem, PrincessEnvironment.toSeq(newArgs));
        }
    }

    static class PrincessBitvectorToBooleanDeclaration
    extends AbstractDeclaration<Predicate> {
        PrincessBitvectorToBooleanDeclaration(Predicate pPredicate) {
            super(pPredicate);
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            ITerm arg0 = (ITerm)args.get(0);
            Sort sort = Sort$.MODULE$.sortOf(arg0);
            Option<Object> bitWidth = PrincessEnvironment.getBitWidth(sort);
            Preconditions.checkArgument((boolean)bitWidth.isDefined(), (String)"BitvectorFormula with actual type %s: %s", (Object)sort, (Object)arg0);
            int bitsize = (Integer)bitWidth.get();
            ArrayList<Object> newArgs = new ArrayList<Object>();
            newArgs.add(new IIntLit(IdealInt.apply((int)bitsize)));
            for (IExpression arg : args) {
                newArgs.add((ITerm)arg);
            }
            return new IAtom((Predicate)this.declarationItem, PrincessEnvironment.toSeq(newArgs));
        }
    }

    static class PrincessByExampleDeclaration
    extends AbstractDeclaration<IExpression> {
        PrincessByExampleDeclaration(IExpression pExample) {
            super(pExample);
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            return ((IExpression)this.declarationItem).update(PrincessEnvironment.toSeq(args));
        }
    }

    static class PrincessIFunctionDeclaration
    extends AbstractDeclaration<IFunction> {
        PrincessIFunctionDeclaration(IFunction pApp) {
            super(pApp);
        }

        @Override
        public IExpression makeApp(PrincessEnvironment env, List<IExpression> args) {
            Preconditions.checkArgument((args.size() == ((IFunction)this.declarationItem).arity() ? 1 : 0) != 0, (Object)"functiontype has different number of args.");
            ArrayList<ITerm> argsList = new ArrayList<ITerm>();
            for (IExpression arg : args) {
                Object termArg = arg instanceof IFormula ? new ITermITE((IFormula)arg, (ITerm)new IIntLit(IdealInt.ZERO()), (ITerm)new IIntLit(IdealInt.ONE())) : (ITerm)arg;
                argsList.add((ITerm)termArg);
            }
            Seq argsBuf = PrincessEnvironment.toSeq(argsList);
            IFunApp returnFormula = new IFunApp((IFunction)this.declarationItem, argsBuf);
            Sort returnType = SortedIFunction$.MODULE$.iResultSort((IFunction)this.declarationItem, returnFormula.args());
            if (returnType == PrincessEnvironment.BOOL_SORT) {
                IExpression.BooleanFunApplier ap = new IExpression.BooleanFunApplier((IFunction)this.declarationItem);
                return ap.apply(argsBuf);
            }
            return returnFormula;
        }
    }

    private static abstract class AbstractDeclaration<T>
    extends PrincessFunctionDeclaration {
        protected final T declarationItem;

        AbstractDeclaration(T pDeclaration) {
            this.declarationItem = pDeclaration;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AbstractDeclaration)) {
                return false;
            }
            AbstractDeclaration other = (AbstractDeclaration)o;
            return this.declarationItem.equals(other.declarationItem);
        }

        @Override
        abstract IExpression makeApp(PrincessEnvironment var1, List<IExpression> var2);

        public int hashCode() {
            return this.declarationItem.hashCode();
        }

        public String toString() {
            return this.declarationItem.toString();
        }
    }
}

