/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.api.PartialModel;
import ap.api.SimpleAPI;
import ap.parser.IFormula;
import ap.parser.IFunction;
import ap.parser.ITerm;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.basicimpl.CachingModel;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessModel;
import scala.Enumeration;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Set;

abstract class PrincessAbstractProver<E>
extends AbstractProverWithAllSat<E> {
    protected final SimpleAPI api;
    protected final PrincessFormulaManager mgr;
    protected final Deque<Level> trackingStack = new ArrayDeque<Level>();
    protected final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    protected final Deque<PersistentMap<Integer, BooleanFormula>> partitions = new ArrayDeque<PersistentMap<Integer, BooleanFormula>>();
    private final PrincessFormulaCreator creator;
    protected boolean wasLastSatCheckSat = false;

    protected PrincessAbstractProver(PrincessFormulaManager pMgr, PrincessFormulaCreator creator, SimpleAPI pApi, ShutdownNotifier pShutdownNotifier, java.util.Set<SolverContext.ProverOptions> pOptions) {
        super(pOptions, pMgr.getBooleanFormulaManager(), pShutdownNotifier);
        this.mgr = pMgr;
        this.creator = creator;
        this.api = (SimpleAPI)Preconditions.checkNotNull((Object)pApi);
        this.trackingStack.push(new Level());
        this.partitions.push((PersistentMap<Integer, BooleanFormula>)PathCopyingPersistentTreeMap.of());
    }

    @Override
    public boolean isUnsat() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        Enumeration.Value result = this.api.checkSat(true);
        if (result.equals((Object)SimpleAPI.ProverStatus$.MODULE$.Sat())) {
            this.wasLastSatCheckSat = true;
            return false;
        }
        if (result.equals((Object)SimpleAPI.ProverStatus$.MODULE$.Unsat())) {
            return true;
        }
        if (result.equals((Object)SimpleAPI.ProverStatus$.MODULE$.OutOfMemory())) {
            throw new SolverException("Princess ran out of stack or heap memory, try increasing their sizes.");
        }
        throw new SolverException("Princess' checkSat call returned " + result);
    }

    @CanIgnoreReturnValue
    protected int addConstraint0(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        int formulaId = this.idGenerator.getFreshId();
        this.partitions.push((PersistentMap<Integer, BooleanFormula>)this.partitions.pop().putAndCopy((Object)formulaId, (Object)constraint));
        this.api.setPartitionNumber(formulaId);
        IFormula t = (IFormula)this.mgr.extractInfo(constraint);
        this.api.addAssertion(this.api.abbrevSharedExpressions(t, ((PrincessEnvironment)this.creator.getEnv()).getMinAtomsForAbbreviation()));
        return formulaId;
    }

    @Override
    protected final void pushImpl() {
        this.wasLastSatCheckSat = false;
        this.api.push();
        this.trackingStack.push(new Level());
        this.partitions.push(this.partitions.peek());
    }

    @Override
    protected void popImpl() {
        this.wasLastSatCheckSat = false;
        this.api.pop();
        Level level = this.trackingStack.pop();
        this.api.addBooleanVariables((Iterable)JavaConverters.asScala(level.booleanSymbols));
        this.api.addConstants((Iterable)JavaConverters.asScala(level.intSymbols));
        level.functionSymbols.forEach(arg_0 -> ((SimpleAPI)this.api).addFunction(arg_0));
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.peek().mergeWithHigher(level);
        }
        this.partitions.pop();
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.wasLastSatCheckSat, (Object)"Model computation failed. Are the pushed formulae satisfiable?");
        this.checkGenerateModels();
        return new CachingModel(this.getEvaluatorWithoutChecks());
    }

    @Override
    protected PrincessModel getEvaluatorWithoutChecks() throws SolverException {
        PartialModel partialModel;
        try {
            partialModel = this.partialModel();
        }
        catch (SimpleAPI.SimpleAPIException ex) {
            throw new SolverException(ex.getMessage(), ex);
        }
        return new PrincessModel(this, partialModel, this.creator, this.api);
    }

    private PartialModel partialModel() throws SimpleAPI.SimpleAPIException {
        return this.api.partialModel();
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Solving with assumptions is not supported.");
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        java.util.Set core = JavaConverters.asJava((Set)this.api.getUnsatCore());
        for (Object partitionId : core) {
            result.add((BooleanFormula)this.partitions.peek().get(partitionId));
        }
        return result;
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) {
        throw new UnsupportedOperationException("UNSAT cores over assumptions not supported by Princess");
    }

    @Override
    public void close() {
        Preconditions.checkNotNull((Object)this.api);
        Preconditions.checkNotNull((Object)this.mgr);
        if (!this.closed) {
            this.api.shutDown();
            this.api.reset();
            ((PrincessEnvironment)this.creator.getEnv()).unregisterStack(this);
            this.partitions.clear();
        }
        super.close();
    }

    @Override
    public <T> T allSat(BasicProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        T result = super.allSat(callback, important);
        this.wasLastSatCheckSat = false;
        return result;
    }

    void addSymbol(IFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.api.addBooleanVariable(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.peek().booleanSymbols.add(f);
        }
    }

    void addSymbol(ITerm f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.api.addConstant(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.peek().intSymbols.add(f);
        }
    }

    void addSymbol(IFunction f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.api.addFunction(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.peek().functionSymbols.add(f);
        }
    }

    static class Level {
        final List<IFormula> booleanSymbols = new ArrayList<IFormula>();
        final List<ITerm> intSymbols = new ArrayList<ITerm>();
        final List<IFunction> functionSymbols = new ArrayList<IFunction>();

        Level() {
        }

        void mergeWithHigher(Level other) {
            this.booleanSymbols.addAll(other.booleanSymbols);
            this.intSymbols.addAll(other.intSymbols);
            this.functionSymbols.addAll(other.functionSymbols);
        }

        public String toString() {
            return String.format("{%s, %s, %s}", this.booleanSymbols, this.intSymbols, this.functionSymbols);
        }
    }
}

