/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaCreator;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;

class OpenSmtIntegerFormulaManager
extends OpenSmtNumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    OpenSmtIntegerFormulaManager(OpenSmtFormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
    }

    @Override
    protected SRef getNumeralType() {
        return (SRef)this.getFormulaCreator().getIntegerType();
    }

    @Override
    protected PTRef makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected PTRef makeNumberImpl(BigDecimal pNumber) {
        return (PTRef)this.decimalAsInteger(pNumber);
    }

    @Override
    protected PTRef divide(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkIntDiv(pParam1, pParam2);
    }

    @Override
    protected PTRef modularCongruence(PTRef pNumber1, PTRef pNumber2, long pModulo) {
        return this.modularCongruence(pNumber1, pNumber2, BigInteger.valueOf(pModulo));
    }

    @Override
    protected PTRef modularCongruence(PTRef pNumber1, PTRef pNumber2, BigInteger pModulo) {
        if (BigInteger.ZERO.compareTo(pModulo) < 0) {
            PTRef n = this.makeNumberImpl(pModulo);
            PTRef x = this.subtract(pNumber1, pNumber2);
            return this.osmtLogic.mkEq(x, this.osmtLogic.mkTimes(n, this.osmtLogic.mkIntDiv(x, n)));
        }
        return this.osmtLogic.getTerm_true();
    }
}

