/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5AbstractProver;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

class Mathsat5Model
extends AbstractModel<Long, Long, Long> {
    private final long model;
    private final Mathsat5FormulaCreator formulaCreator;
    private final Mathsat5AbstractProver<?> prover;

    Mathsat5Model(long model, Mathsat5FormulaCreator creator, Mathsat5AbstractProver<?> pProver) {
        super(pProver, creator);
        this.model = model;
        this.formulaCreator = creator;
        this.prover = pProver;
    }

    @Override
    public ImmutableList<Model.ValueAssignment> asList() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkState((!this.prover.isClosed() ? 1 : 0) != 0, (Object)"cannot use model after prover is closed");
        ImmutableList.Builder assignments = ImmutableList.builder();
        long modelIterator = Mathsat5NativeApi.msat_model_create_iterator(this.model);
        while (Mathsat5NativeApi.msat_model_iterator_has_next(modelIterator)) {
            long[] key = new long[1];
            long[] value = new long[1];
            if (Mathsat5NativeApi.msat_model_iterator_next(modelIterator, key, value)) {
                throw new NoSuchElementException();
            }
            if (Mathsat5NativeApi.msat_is_array_type((Long)this.creator.getEnv(), Mathsat5NativeApi.msat_term_get_type(value[0]))) {
                assignments.addAll(this.getArrayAssignments(key[0], key[0], value[0], (List<Object>)ImmutableList.of()));
                continue;
            }
            assignments.add((Object)this.getAssignment(key[0], value[0]));
        }
        Mathsat5NativeApi.msat_destroy_model_iterator(modelIterator);
        return assignments.build();
    }

    private Model.ValueAssignment getAssignment(long key, long value) {
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (int i = 0; i < Mathsat5NativeApi.msat_term_arity(key); ++i) {
            long arg = Mathsat5NativeApi.msat_term_get_arg(key, i);
            argumentInterpretation.add(this.evaluateImpl(arg));
        }
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(key), this.creator.encapsulateWithTypeOf(value), this.creator.encapsulateBoolean(Mathsat5NativeApi.msat_make_eq((Long)this.creator.getEnv(), key, value)), this.formulaCreator.getName(key), this.formulaCreator.convertValue(key, value), argumentInterpretation);
    }

    private Collection<Model.ValueAssignment> getArrayAssignments(long symbol, long key, long array, List<Object> upperIndices) {
        ArrayList<Model.ValueAssignment> assignments = new ArrayList<Model.ValueAssignment>();
        HashSet<Long> indices = new HashSet<Long>();
        while (Mathsat5NativeApi.msat_term_is_array_write((Long)this.creator.getEnv(), array)) {
            long index = Mathsat5NativeApi.msat_term_get_arg(array, 1);
            long content = Mathsat5NativeApi.msat_term_get_arg(array, 2);
            array = Mathsat5NativeApi.msat_term_get_arg(array, 0);
            if (!indices.add(index)) continue;
            ArrayList<Object> innerIndices = new ArrayList<Object>(upperIndices);
            innerIndices.add(this.evaluateImpl(index));
            long select = Mathsat5NativeApi.msat_make_array_read((Long)this.creator.getEnv(), key, index);
            if (Mathsat5NativeApi.msat_is_array_type((Long)this.creator.getEnv(), Mathsat5NativeApi.msat_term_get_type(content))) {
                assignments.addAll(this.getArrayAssignments(symbol, select, content, innerIndices));
                continue;
            }
            assignments.add(new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(select), this.creator.encapsulateWithTypeOf(content), this.creator.encapsulateBoolean(Mathsat5NativeApi.msat_make_eq((Long)this.creator.getEnv(), select, content)), this.formulaCreator.getName(symbol), this.evaluateImpl(content), innerIndices));
        }
        return assignments;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            Mathsat5NativeApi.msat_destroy_model(this.model);
        }
        super.close();
    }

    @Override
    protected Long evalImpl(Long formula) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkState((!this.prover.isClosed() ? 1 : 0) != 0, (Object)"cannot use model after prover is closed");
        return Mathsat5NativeApi.msat_model_eval(this.model, formula);
    }
}

