/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.collect.ImmutableSet;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Kind;
import io.github.cvc5.Solver;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Pattern;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;

abstract class CVC5NumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Term, Sort, Solver, ParamFormulaType, ResultFormulaType, Term> {
    public static final Pattern INTEGER_NUMBER = Pattern.compile("(-)?(\\d)+");
    public static final Pattern RATIONAL_NUMBER = Pattern.compile("(-)?(\\d)+(.)?(\\d)*");
    private static final ImmutableSet<Kind> NUMERIC_FUNCTIONS = ImmutableSet.of((Object)Kind.ADD, (Object)Kind.SUB, (Object)Kind.MULT, (Object)Kind.DIVISION, (Object)Kind.INTS_DIVISION, (Object)Kind.INTS_MODULUS, (Object[])new Kind[0]);
    protected final Solver solver;

    CVC5NumeralFormulaManager(CVC5FormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
        this.solver = (Solver)pCreator.getEnv();
    }

    protected abstract Sort getNumeralType();

    @Override
    protected boolean isNumeral(Term pVal) {
        return pVal.isIntegerValue() || pVal.isRealValue();
    }

    @Override
    protected Term makeNumberImpl(long i) {
        return this.makeNumberImpl(Long.toString(i));
    }

    @Override
    protected Term makeNumberImpl(BigInteger pI) {
        return this.makeNumberImpl(pI.toString());
    }

    @Override
    protected Term makeNumberImpl(String pI) {
        if (!RATIONAL_NUMBER.matcher(pI).matches()) {
            throw new NumberFormatException("number is not an rational value: " + pI);
        }
        try {
            return this.solver.mkReal(pI);
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("You tried creating a invalid rational number with input Sring: " + pI + ".", e);
        }
    }

    @Override
    protected Term makeVariableImpl(String varName) {
        Sort type = this.getNumeralType();
        return (Term)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Term multiply(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.MULT, pParam1, pParam2);
    }

    @Override
    protected Term modulo(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.INTS_MODULUS, pParam1, pParam2);
    }

    @Override
    protected Term negate(Term pParam1) {
        return this.solver.mkTerm(Kind.NEG, pParam1);
    }

    @Override
    protected Term add(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.ADD, pParam1, pParam2);
    }

    @Override
    protected Term subtract(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.SUB, pParam1, pParam2);
    }

    @Override
    protected Term equal(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.EQUAL, pParam1, pParam2);
    }

    @Override
    protected Term greaterThan(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.GT, pParam1, pParam2);
    }

    @Override
    protected Term greaterOrEquals(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.GEQ, pParam1, pParam2);
    }

    @Override
    protected Term lessThan(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.LT, pParam1, pParam2);
    }

    @Override
    protected Term lessOrEquals(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.LEQ, pParam1, pParam2);
    }

    @Override
    protected Term distinctImpl(List<Term> pParam) {
        return this.solver.mkTerm(Kind.DISTINCT, pParam.toArray(new Term[0]));
    }
}

