/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;

class Z3BooleanFormulaManager
extends AbstractBooleanFormulaManager<Long, Long, Long, Long> {
    private final long z3context;
    private final Long z3true;
    private final Long z3false;

    Z3BooleanFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
        this.z3true = Native.mkTrue((long)this.z3context);
        Native.incRef((long)this.z3context, (long)this.z3true);
        this.z3false = Native.mkFalse((long)this.z3context);
        Native.incRef((long)this.z3context, (long)this.z3false);
    }

    @Override
    protected Long makeVariableImpl(String varName) {
        long type = (Long)this.getFormulaCreator().getBoolType();
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Long makeBooleanImpl(boolean pValue) {
        return pValue ? this.z3true : this.z3false;
    }

    @Override
    protected Long not(Long pParam) {
        if (this.isTrue(pParam)) {
            return this.z3false;
        }
        if (this.isFalse(pParam)) {
            return this.z3true;
        }
        if (Z3FormulaCreator.isOP(this.z3context, pParam, Z3_decl_kind.Z3_OP_NOT)) {
            return Native.getAppArg((long)this.z3context, (long)pParam, (int)0);
        }
        return Native.mkNot((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long and(Long pParam1, Long pParam2) {
        if (this.isTrue(pParam1)) {
            return pParam2;
        }
        if (this.isTrue(pParam2)) {
            return pParam1;
        }
        if (this.isFalse(pParam1)) {
            return this.z3false;
        }
        if (this.isFalse(pParam2)) {
            return this.z3false;
        }
        if (Native.isEqAst((long)this.z3context, (long)pParam1, (long)pParam2)) {
            return pParam1;
        }
        return Native.mkAnd((long)this.z3context, (int)2, (long[])new long[]{pParam1, pParam2});
    }

    @Override
    protected Long or(Long pParam1, Long pParam2) {
        if (this.isTrue(pParam1)) {
            return this.z3true;
        }
        if (this.isTrue(pParam2)) {
            return this.z3true;
        }
        if (this.isFalse(pParam1)) {
            return pParam2;
        }
        if (this.isFalse(pParam2)) {
            return pParam1;
        }
        if (Native.isEqAst((long)this.z3context, (long)pParam1, (long)pParam2)) {
            return pParam1;
        }
        return Native.mkOr((long)this.z3context, (int)2, (long[])new long[]{pParam1, pParam2});
    }

    @Override
    protected Long orImpl(Collection<Long> params) {
        LinkedHashSet<Long> operands = new LinkedHashSet<Long>();
        for (Long operand : params) {
            if (this.isTrue(operand)) {
                return this.z3true;
            }
            if (this.isFalse(operand)) continue;
            operands.add(operand);
        }
        switch (operands.size()) {
            case 0: {
                return this.z3false;
            }
            case 1: {
                return (Long)Iterables.getOnlyElement(operands);
            }
        }
        return Native.mkOr((long)this.z3context, (int)operands.size(), (long[])Longs.toArray(operands));
    }

    @Override
    protected Long andImpl(Collection<Long> params) {
        LinkedHashSet<Long> operands = new LinkedHashSet<Long>();
        for (Long operand : params) {
            if (this.isFalse(operand)) {
                return this.z3false;
            }
            if (this.isTrue(operand)) continue;
            operands.add(operand);
        }
        switch (operands.size()) {
            case 0: {
                return this.z3true;
            }
            case 1: {
                return (Long)Iterables.getOnlyElement(operands);
            }
        }
        return Native.mkAnd((long)this.z3context, (int)operands.size(), (long[])Longs.toArray(operands));
    }

    @Override
    protected Long xor(Long pParam1, Long pParam2) {
        return Native.mkXor((long)this.z3context, (long)pParam1, (long)pParam2);
    }

    @Override
    protected Long equivalence(Long pBits1, Long pBits2) {
        return Native.mkEq((long)this.z3context, (long)pBits1, (long)pBits2);
    }

    @Override
    protected Long implication(Long pBits1, Long pBits2) {
        return Native.mkImplies((long)this.z3context, (long)pBits1, (long)pBits2);
    }

    @Override
    protected boolean isTrue(Long pParam) {
        return Z3FormulaCreator.isOP(this.z3context, pParam, Z3_decl_kind.Z3_OP_TRUE);
    }

    @Override
    protected boolean isFalse(Long pParam) {
        return Z3FormulaCreator.isOP(this.z3context, pParam, Z3_decl_kind.Z3_OP_FALSE);
    }

    @Override
    protected Long ifThenElse(Long pCond, Long pF1, Long pF2) {
        if (this.isTrue(pCond)) {
            return pF1;
        }
        if (this.isFalse(pCond)) {
            return pF2;
        }
        if (pF1.equals(pF2)) {
            return pF1;
        }
        if (this.isTrue(pF1) && this.isFalse(pF2)) {
            return pCond;
        }
        if (this.isFalse(pF1) && this.isTrue(pF2)) {
            return this.not(pCond);
        }
        return Native.mkIte((long)this.z3context, (long)pCond, (long)pF1, (long)pF2);
    }
}

