/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractEnumerationFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

public class Mathsat5EnumerationFormulaManager
extends AbstractEnumerationFormulaManager<Long, Long, Long, Long> {
    private final long mathsatEnv;

    protected Mathsat5EnumerationFormulaManager(FormulaCreator<Long, Long, Long, Long> pCreator) {
        super(pCreator);
        this.mathsatEnv = pCreator.getEnv();
    }

    @Override
    protected AbstractEnumerationFormulaManager.EnumType declareEnumeration0(FormulaType.EnumerationFormulaType pType) {
        for (AbstractEnumerationFormulaManager.EnumType existingType : this.enumerations.values()) {
            Preconditions.checkArgument((boolean)Iterables.all(pType.getElements(), e -> !existingType.hasConstants((String)e)), (String)"Enumeration type '%s' has elements that already appear in enumeration type '%s'.", (Object)pType, (Object)existingType.getEnumerationFormulaType());
        }
        String[] elements = (String[])pType.getElements().toArray((Object[])new String[0]);
        long enumType = Mathsat5NativeApi.msat_get_enum_type(this.mathsatEnv, pType.getName(), elements.length, elements);
        long[] constantDecls = Mathsat5NativeApi.msat_get_enum_constants(this.mathsatEnv, enumType);
        ImmutableMap.Builder constantsMapping = ImmutableMap.builder();
        for (int i = 0; i < elements.length; ++i) {
            long constant = Mathsat5NativeApi.msat_make_term(this.mathsatEnv, constantDecls[i], new long[0]);
            constantsMapping.put((Object)elements[i], (Object)constant);
        }
        return new AbstractEnumerationFormulaManager.EnumType(pType, enumType, constantsMapping.buildOrThrow());
    }

    @Override
    protected Long equivalenceImpl(Long pF1, Long pF2) {
        return Mathsat5NativeApi.msat_make_equal(this.mathsatEnv, pF1, pF2);
    }
}

