/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.github.cvc5.Solver;
import java.util.Set;
import java.util.function.Consumer;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5ArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5BitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5EnumerationFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5IntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5QuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5RationalFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5SLFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5StringFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5TheoremProver;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5UFManager;

public final class CVC5SolverContext
extends AbstractSolverContext {
    private CVC5FormulaCreator creator;
    private final Solver solver;
    private final ShutdownNotifier shutdownNotifier;
    private final int randomSeed;
    private boolean closed = false;

    private CVC5SolverContext(CVC5FormulaCreator pCreator, CVC5FormulaManager manager, ShutdownNotifier pShutdownNotifier, Solver pSolver, int pRandomSeed) {
        super(manager);
        this.creator = pCreator;
        this.shutdownNotifier = pShutdownNotifier;
        this.randomSeed = pRandomSeed;
        this.solver = pSolver;
    }

    @VisibleForTesting
    static void loadLibrary(Consumer<String> pLoader) {
        pLoader.accept("cvc5jni");
        System.setProperty("cvc5.skipLibraryLoad", "true");
    }

    public static SolverContext create(LogManager pLogger, ShutdownNotifier pShutdownNotifier, int randomSeed, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic, FloatingPointRoundingMode pFloatingPointRoundingMode, Consumer<String> pLoader) {
        CVC5SolverContext.loadLibrary(pLoader);
        Solver newSolver = new Solver();
        CVC5SolverContext.setSolverOptions(newSolver, randomSeed);
        CVC5FormulaCreator pCreator = new CVC5FormulaCreator(newSolver);
        CVC5UFManager functionTheory = new CVC5UFManager(pCreator);
        CVC5BooleanFormulaManager booleanTheory = new CVC5BooleanFormulaManager(pCreator);
        CVC5IntegerFormulaManager integerTheory = new CVC5IntegerFormulaManager(pCreator, pNonLinearArithmetic);
        CVC5RationalFormulaManager rationalTheory = new CVC5RationalFormulaManager(pCreator, pNonLinearArithmetic);
        CVC5BitvectorFormulaManager bitvectorTheory = new CVC5BitvectorFormulaManager(pCreator, booleanTheory);
        CVC5FloatingPointFormulaManager fpTheory = new CVC5FloatingPointFormulaManager(pCreator, pFloatingPointRoundingMode);
        CVC5QuantifiedFormulaManager qfTheory = new CVC5QuantifiedFormulaManager(pCreator);
        CVC5ArrayFormulaManager arrayTheory = new CVC5ArrayFormulaManager(pCreator);
        CVC5SLFormulaManager slTheory = new CVC5SLFormulaManager(pCreator);
        CVC5StringFormulaManager strTheory = new CVC5StringFormulaManager(pCreator);
        CVC5EnumerationFormulaManager enumTheory = new CVC5EnumerationFormulaManager(pCreator);
        CVC5FormulaManager manager = new CVC5FormulaManager(pCreator, functionTheory, booleanTheory, integerTheory, rationalTheory, bitvectorTheory, fpTheory, qfTheory, arrayTheory, slTheory, strTheory, enumTheory);
        return new CVC5SolverContext(pCreator, manager, pShutdownNotifier, newSolver, randomSeed);
    }

    private static void setSolverOptions(Solver pSolver, int randomSeed) {
        pSolver.setOption("seed", String.valueOf(randomSeed));
        pSolver.setOption("output-language", "smtlib2");
    }

    @Override
    public String getVersion() {
        String version = this.solver.getInfo("version");
        if (version.startsWith("\"") && version.endsWith("\"")) {
            version = version.substring(1, version.length() - 1);
        }
        return "CVC5 " + version;
    }

    @Override
    public void close() {
        if (this.creator != null) {
            this.closed = true;
            this.solver.deletePointer();
            this.creator = null;
        }
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.CVC5;
    }

    @Override
    public ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> pOptions) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"solver context is already closed");
        return new CVC5TheoremProver(this.creator, this.shutdownNotifier, this.randomSeed, pOptions, this.getFormulaManager());
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return false;
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> pOptions) {
        throw new UnsupportedOperationException("CVC5 does not support Craig interpolation.");
    }

    @Override
    protected OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> pSet) {
        throw new UnsupportedOperationException("CVC5 does not support optimization");
    }
}

