/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.base.Preconditions;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.SmtEngine;
import edu.stanford.CVC4.Type;
import org.sosy_lab.java_smt.basicimpl.AbstractEvaluator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4TheoremProver;

public class CVC4Evaluator
extends AbstractEvaluator<Expr, Type, ExprManager> {
    private final SmtEngine smtEngine;
    private final CVC4TheoremProver prover;

    CVC4Evaluator(CVC4TheoremProver pProver, CVC4FormulaCreator pCreator, SmtEngine pSmtEngine) {
        super(pProver, pCreator);
        this.smtEngine = pSmtEngine;
        this.prover = pProver;
    }

    @Override
    public Expr evalImpl(Expr f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        return this.getValue(f);
    }

    private Expr getValue(Expr f) {
        return this.prover.exportExpr(this.smtEngine.getValue(this.prover.importExpr(f)));
    }
}

