/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Evaluator;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProver;

public abstract class AbstractProverWithAllSat<T>
extends AbstractProver<T> {
    protected final ShutdownNotifier shutdownNotifier;
    private final BooleanFormulaManager bmgr;
    protected boolean closed;

    protected AbstractProverWithAllSat(Set<SolverContext.ProverOptions> pOptions, BooleanFormulaManager pBmgr, ShutdownNotifier pShutdownNotifier) {
        super(pOptions);
        this.bmgr = pBmgr;
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> importantPredicates) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateAllSat();
        this.push();
        try {
            this.iterateOverAllModels(callback, importantPredicates);
        }
        catch (SolverException e) {
            this.iterateOverAllPredicateCombinations(callback, importantPredicates, new ArrayDeque<BooleanFormula>());
        }
        this.pop();
        return callback.getResult();
    }

    private <R> void iterateOverAllModels(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> importantPredicates) throws SolverException, InterruptedException {
        while (!this.isUnsat()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ImmutableList.Builder valuesOfModel = ImmutableList.builder();
            try (Evaluator evaluator = this.getEvaluatorWithoutChecks();){
                for (BooleanFormula formula : importantPredicates) {
                    Boolean value = evaluator.evaluate(formula);
                    if (value == null) continue;
                    if (value.booleanValue()) {
                        valuesOfModel.add((Object)formula);
                        continue;
                    }
                    valuesOfModel.add((Object)this.bmgr.not(formula));
                }
            }
            ImmutableList values = valuesOfModel.build();
            callback.apply((List<BooleanFormula>)values);
            this.shutdownNotifier.shutdownIfNecessary();
            BooleanFormula negatedModel = this.bmgr.not(this.bmgr.and((Collection<BooleanFormula>)values));
            this.addConstraint(negatedModel);
            this.shutdownNotifier.shutdownIfNecessary();
        }
    }

    private <R> void iterateOverAllPredicateCombinations(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> predicates, Deque<BooleanFormula> valuesOfModel) throws SolverException, InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        if (this.isUnsat()) {
            return;
        }
        if (predicates.isEmpty()) {
            callback.apply((List<BooleanFormula>)ImmutableList.copyOf(valuesOfModel).reverse());
        } else {
            BooleanFormula predicate = predicates.get(0);
            valuesOfModel.push(predicate);
            this.push(predicate);
            this.iterateOverAllPredicateCombinations(callback, predicates.subList(1, predicates.size()), valuesOfModel);
            this.pop();
            valuesOfModel.pop();
            BooleanFormula notPredicate = this.bmgr.not(predicates.get(0));
            valuesOfModel.push(notPredicate);
            this.push(notPredicate);
            this.iterateOverAllPredicateCombinations(callback, predicates.subList(1, predicates.size()), valuesOfModel);
            this.pop();
            valuesOfModel.pop();
        }
    }

    protected abstract Evaluator getEvaluatorWithoutChecks() throws SolverException;
}

