/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.api.SimpleAPI;
import ap.basetypes.Tree;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IFormula;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.Traverser;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.princess.PrincessAbstractProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaManager;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

class PrincessInterpolatingProver
extends PrincessAbstractProver<Integer, Integer>
implements InterpolatingProverEnvironment<Integer> {
    private final Map<Integer, IFormula> annotatedTerms = new HashMap<Integer, IFormula>();
    private static final UniqueIdGenerator counter = new UniqueIdGenerator();

    PrincessInterpolatingProver(PrincessFormulaManager pMgr, PrincessFormulaCreator creator, SimpleAPI pApi, ShutdownNotifier pShutdownNotifier, Set<SolverContext.ProverOptions> pOptions) {
        super(pMgr, creator, pApi, pShutdownNotifier, pOptions);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ((List)this.assertedFormulas.peek()).forEach(this.annotatedTerms::remove);
        super.pop();
    }

    @Override
    public Integer addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        int termIndex = counter.getFreshId();
        IFormula t = (IFormula)this.mgr.extractInfo(f);
        this.api.setPartitionNumber(termIndex);
        this.addConstraint0(t);
        this.api.setPartitionNumber(-1);
        ((List)this.assertedFormulas.peek()).add(termIndex);
        this.annotatedTerms.put(termIndex, t);
        return termIndex;
    }

    @Override
    protected Iterable<IExpression> getAssertedFormulas() {
        return FluentIterable.concat((Iterable)this.assertedFormulas).transform(this.annotatedTerms::get);
    }

    @Override
    public BooleanFormula getInterpolant(Collection<Integer> pTermNamesOfA) throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ImmutableSet indexesOfA = ImmutableSet.copyOf(pTermNamesOfA);
        Set indexesOfB = (Set)this.annotatedTerms.keySet().stream().filter(arg_0 -> PrincessInterpolatingProver.lambda$getInterpolant$0((Set)indexesOfA, arg_0)).collect(ImmutableSet.toImmutableSet());
        List<BooleanFormula> itp = this.getSeqInterpolants((List<? extends Collection<Integer>>)ImmutableList.of((Object)indexesOfA, (Object)indexesOfB));
        assert (itp.size() == 1);
        return itp.get(0);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<Integer>> partitions) throws SolverException {
        scala.collection.immutable.Seq itps;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"at least one partition should be available.");
        ArrayBuffer args = new ArrayBuffer();
        for (Collection<Integer> collection : partitions) {
            args.$plus$eq((Object)JavaConverters.asScala(collection).toSet());
        }
        try {
            itps = this.api.getInterpolants(args.toSeq(), this.api.getInterpolants$default$2());
        }
        catch (StackOverflowError stackOverflowError) {
            throw new SolverException("Princess ran out of stack memory, try increasing the stack size.", stackOverflowError);
        }
        assert (itps.length() == partitions.size() - 1) : "There should be (n-1) interpolants for n partitions";
        ArrayList<BooleanFormula> arrayList = new ArrayList<BooleanFormula>();
        for (IFormula itp : JavaConverters.asJava((Seq)itps)) {
            arrayList.add(this.mgr.encapsulateBooleanFormula((IExpression)itp));
        }
        return arrayList;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<Integer>> partitionedFormulas, int[] startOfSubTree) throws SolverException {
        Tree itps;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        assert (InterpolatingProverEnvironment.checkTreeStructure(partitionedFormulas.size(), startOfSubTree));
        ArrayDeque<Tree> stack = new ArrayDeque<Tree>();
        ArrayDeque<Integer> subtreeStarts = new ArrayDeque<Integer>();
        for (int i = 0; i < partitionedFormulas.size(); ++i) {
            Preconditions.checkState((stack.size() == subtreeStarts.size() ? 1 : 0) != 0);
            int start = startOfSubTree[i];
            ArrayBuffer children = new ArrayBuffer();
            while (!subtreeStarts.isEmpty() && start <= (Integer)subtreeStarts.peek()) {
                subtreeStarts.pop();
                children.$plus$eq$colon((Object)((Tree)stack.pop()));
            }
            subtreeStarts.push(start);
            stack.push(new Tree((Object)JavaConverters.asScala(partitionedFormulas.get(i)).toSet(), children.toList()));
        }
        Preconditions.checkState(((Integer)subtreeStarts.peek() == 0 ? 1 : 0) != 0, (Object)"subtree of root should start at 0.");
        Tree root = (Tree)stack.pop();
        Preconditions.checkState((boolean)stack.isEmpty(), (Object)"root should be last element in stack.");
        try {
            itps = this.api.getTreeInterpolant(root, this.api.getTreeInterpolant$default$2());
        }
        catch (StackOverflowError e) {
            throw new SolverException("Princess ran out of stack memory, try increasing the stack size.", e);
        }
        List<BooleanFormula> result = this.tree2List((Tree<IFormula>)itps);
        assert (result.size() == startOfSubTree.length - 1);
        return result;
    }

    private List<BooleanFormula> tree2List(Tree<IFormula> tree) {
        ImmutableList lst = FluentIterable.from((Iterable)Traverser.forTree(node -> JavaConverters.asJava((Seq)node.children())).depthFirstPostOrder(tree)).transform(node -> this.mgr.encapsulateBooleanFormula((IExpression)node.d())).toList();
        assert (((BooleanFormula)Iterables.getLast((Iterable)lst)).equals(this.mgr.encapsulateBooleanFormula((IExpression)new IBoolLit(false))));
        return lst.subList(0, lst.size() - 1);
    }

    private static /* synthetic */ boolean lambda$getInterpolant$0(Set indexesOfA, Integer f) {
        return !indexesOfA.contains(f);
    }
}

