/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5AbstractProver;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5SolverContext;

class Mathsat5TheoremProver
extends Mathsat5AbstractProver<Void>
implements ProverEnvironment {
    Mathsat5TheoremProver(Mathsat5SolverContext pMgr, ShutdownNotifier pShutdownNotifier, Mathsat5FormulaCreator creator, Set<SolverContext.ProverOptions> options) {
        super(pMgr, options, creator, pShutdownNotifier);
    }

    @Override
    protected void createConfig(Map<String, String> pConfig) {
    }

    @Override
    public @Nullable Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closeAllEvaluators();
        Mathsat5NativeApi.msat_assert_formula(this.curEnv, Mathsat5FormulaManager.getMsatTerm(constraint));
        return null;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_push_backtrack_point(this.curEnv);
    }
}

