/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5AbstractProver;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5SolverContext;

class Mathsat5OptimizationProver
extends Mathsat5AbstractProver<Void>
implements OptimizationProverEnvironment {
    private static final int ERROR_TERM = 0;
    private final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private PersistentMap<Integer, Long> objectiveMap = PathCopyingPersistentTreeMap.of();
    private final Deque<PersistentMap<Integer, Long>> stack = new ArrayDeque<PersistentMap<Integer, Long>>();

    Mathsat5OptimizationProver(Mathsat5SolverContext pMgr, ShutdownNotifier pShutdownNotifier, Mathsat5FormulaCreator creator, Set<SolverContext.ProverOptions> options) {
        super(pMgr, options, creator, pShutdownNotifier);
    }

    @Override
    protected void createConfig(Map<String, String> pConfig) {
        pConfig.put("model_generation", "true");
    }

    @Override
    public @Nullable Void addConstraint(BooleanFormula constraint) {
        Mathsat5NativeApi.msat_assert_formula(this.curEnv, Mathsat5FormulaManager.getMsatTerm(constraint));
        return null;
    }

    @Override
    public int maximize(Formula objective) {
        long objectiveId = Mathsat5NativeApi.msat_make_maximize(this.curEnv, Mathsat5FormulaManager.getMsatTerm(objective));
        Mathsat5NativeApi.msat_assert_objective(this.curEnv, objectiveId);
        int id = this.idGenerator.getFreshId();
        this.objectiveMap = this.objectiveMap.putAndCopy((Object)id, (Object)objectiveId);
        return id;
    }

    @Override
    public int minimize(Formula objective) {
        long objectiveId = Mathsat5NativeApi.msat_make_minimize(this.curEnv, Mathsat5FormulaManager.getMsatTerm(objective));
        Mathsat5NativeApi.msat_assert_objective(this.curEnv, objectiveId);
        int id = this.idGenerator.getFreshId();
        this.objectiveMap = this.objectiveMap.putAndCopy((Object)id, (Object)objectiveId);
        return id;
    }

    @Override
    public OptimizationProverEnvironment.OptStatus check() throws InterruptedException, SolverException {
        boolean isSatisfiable = Mathsat5NativeApi.msat_check_sat(this.curEnv);
        if (isSatisfiable) {
            return OptimizationProverEnvironment.OptStatus.OPT;
        }
        return OptimizationProverEnvironment.OptStatus.UNSAT;
    }

    @Override
    public void push() {
        Mathsat5NativeApi.msat_push_backtrack_point(this.curEnv);
        this.stack.add(this.objectiveMap);
    }

    @Override
    public void pop() {
        Mathsat5NativeApi.msat_pop_backtrack_point(this.curEnv);
        this.objectiveMap = this.stack.pop();
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        return this.getValue(handle, epsilon);
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        return this.getValue(handle, epsilon);
    }

    private Optional<Rational> getValue(int handle, Rational epsilon) {
        assert (this.objectiveMap.containsKey((Object)handle)) : "querying an unknown handle";
        long objective = (Long)this.objectiveMap.get((Object)handle);
        int isUnbounded = Mathsat5NativeApi.msat_objective_value_is_unbounded(this.curEnv, objective, 0);
        if (isUnbounded == 1) {
            return Optional.empty();
        }
        assert (isUnbounded == 0);
        long epsilonTerm = Mathsat5NativeApi.msat_make_number(this.curEnv, epsilon.toString());
        long objectiveValue = Mathsat5NativeApi.msat_objective_value_term(this.curEnv, objective, 0, 0L, epsilonTerm);
        return Optional.of(Rational.ofString((String)Mathsat5NativeApi.msat_term_repr(objectiveValue)));
    }

    @Override
    public Model getModel() throws SolverException {
        if (!this.objectiveMap.isEmpty()) {
            Mathsat5NativeApi.msat_load_objective_model(this.curEnv, (Long)this.objectiveMap.values().iterator().next());
        }
        return super.getModel();
    }
}

