/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import io.github.cvc5.Kind;
import io.github.cvc5.Solver;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;

public class CVC5QuantifiedFormulaManager
extends AbstractQuantifiedFormulaManager<Term, Sort, Solver, Term> {
    private final Solver solver;

    protected CVC5QuantifiedFormulaManager(FormulaCreator<Term, Sort, Solver, Term> pFormulaCreator) {
        super(pFormulaCreator);
        this.solver = pFormulaCreator.getEnv();
    }

    @Override
    protected Term eliminateQuantifiers(Term input) throws SolverException, InterruptedException {
        try {
            return this.solver.getQuantifierElimination(input);
        }
        catch (RuntimeException e) {
            return input;
        }
    }

    @Override
    public Term mkQuantifier(QuantifiedFormulaManager.Quantifier pQ, List<Term> pVars, Term pBody) {
        if (pVars.isEmpty()) {
            throw new IllegalArgumentException("Empty variable list for quantifier.");
        }
        ArrayList<Term> boundVars = new ArrayList<Term>();
        Term substBody = pBody;
        for (Term var : pVars) {
            Term boundCopy = ((CVC5FormulaCreator)this.formulaCreator).makeBoundCopy(var);
            boundVars.add(boundCopy);
            substBody = substBody.substitute(var, boundCopy);
        }
        Kind quant = pQ == QuantifiedFormulaManager.Quantifier.EXISTS ? Kind.EXISTS : Kind.FORALL;
        Term boundVarsList = this.solver.mkTerm(Kind.VARIABLE_LIST, boundVars.toArray(new Term[0]));
        return this.solver.mkTerm(quant, boundVarsList, substBody);
    }
}

