/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.collect.ImmutableList;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Kind;
import io.github.cvc5.Op;
import io.github.cvc5.RoundingMode;
import io.github.cvc5.Solver;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import java.math.BigDecimal;
import java.util.List;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;

public class CVC5FloatingPointFormulaManager
extends AbstractFloatingPointFormulaManager<Term, Sort, Solver, Term> {
    private final Solver solver;
    private final Term roundingMode;

    protected CVC5FloatingPointFormulaManager(CVC5FormulaCreator pCreator, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        super(pCreator);
        this.solver = (Solver)pCreator.getEnv();
        this.roundingMode = this.getRoundingModeImpl(pFloatingPointRoundingMode);
    }

    @Override
    protected Term getDefaultRoundingMode() {
        return this.roundingMode;
    }

    @Override
    protected Term getRoundingModeImpl(FloatingPointRoundingMode pFloatingPointRoundingMode) {
        switch (pFloatingPointRoundingMode) {
            case NEAREST_TIES_TO_EVEN: {
                return this.solver.mkRoundingMode(RoundingMode.ROUND_NEAREST_TIES_TO_EVEN);
            }
            case NEAREST_TIES_AWAY: {
                return this.solver.mkRoundingMode(RoundingMode.ROUND_NEAREST_TIES_TO_AWAY);
            }
            case TOWARD_POSITIVE: {
                return this.solver.mkRoundingMode(RoundingMode.ROUND_TOWARD_POSITIVE);
            }
            case TOWARD_NEGATIVE: {
                return this.solver.mkRoundingMode(RoundingMode.ROUND_TOWARD_NEGATIVE);
            }
            case TOWARD_ZERO: {
                return this.solver.mkRoundingMode(RoundingMode.ROUND_TOWARD_ZERO);
            }
        }
        throw new AssertionError((Object)("Unexpected rounding mode encountered: " + pFloatingPointRoundingMode));
    }

    @Override
    protected Term makeNumberImpl(double pN, FormulaType.FloatingPointType pType, Term pRoundingMode) {
        return this.makeNumberImpl(Double.toString(pN), pType, pRoundingMode);
    }

    @Override
    protected Term makeNumberAndRound(String pN, FormulaType.FloatingPointType pType, Term pRoundingMode) {
        try {
            if (CVC5FloatingPointFormulaManager.isNegativeZero(Double.valueOf(pN))) {
                return this.solver.mkFloatingPointNegZero(pType.getExponentSize(), pType.getMantissaSize() + 1);
            }
        }
        catch (CVC5ApiException | NumberFormatException throwable) {
            // empty catch block
        }
        try {
            Rational rationalValue = this.toRational(pN);
            Op realToFp = this.solver.mkOp(Kind.FLOATINGPOINT_TO_FP_FROM_REAL, pType.getExponentSize(), pType.getMantissaSize() + 1);
            return this.solver.mkTerm(realToFp, pRoundingMode, this.solver.mkReal(rationalValue.toString()));
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("You tried creating a invalid floating point with exponent size " + pType.getExponentSize() + ", mantissa size " + pType.getMantissaSize() + " and value " + pN + ".", e);
        }
    }

    private Rational toRational(String pN) throws NumberFormatException {
        try {
            return Rational.ofBigDecimal((BigDecimal)new BigDecimal(pN));
        }
        catch (NumberFormatException e1) {
            try {
                return Rational.ofString((String)pN);
            }
            catch (NumberFormatException e2) {
                throw new NumberFormatException("invalid numeral: " + pN);
            }
        }
    }

    @Override
    protected Term makeVariableImpl(String varName, FormulaType.FloatingPointType pType) {
        return (Term)this.formulaCreator.makeVariable((Sort)this.formulaCreator.getFloatingPointType(pType), varName);
    }

    @Override
    protected Term makePlusInfinityImpl(FormulaType.FloatingPointType pType) {
        try {
            return this.solver.mkFloatingPointPosInf(pType.getExponentSize(), pType.getMantissaSize() + 1);
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("You tried creating a invalid positive floating point +infinity with exponent size " + pType.getExponentSize() + " and mantissa size " + pType.getMantissaSize() + ".", e);
        }
    }

    @Override
    protected Term makeMinusInfinityImpl(FormulaType.FloatingPointType pType) {
        try {
            return this.solver.mkFloatingPointNegInf(pType.getExponentSize(), pType.getMantissaSize() + 1);
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("You tried creating a invalid negative floating point -infinity with exponent size " + pType.getExponentSize() + " and mantissa size " + pType.getMantissaSize() + ".", e);
        }
    }

    @Override
    protected Term makeNaNImpl(FormulaType.FloatingPointType pType) {
        try {
            return this.solver.mkFloatingPointNaN(pType.getExponentSize(), pType.getMantissaSize() + 1);
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("You tried creating a invalid NaN with exponent size " + pType.getExponentSize() + " and mantissa size " + pType.getMantissaSize() + ".", e);
        }
    }

    @Override
    protected Term castToImpl(Term pNumber, boolean pSigned, FormulaType<?> pTargetType, Term pRoundingMode) {
        try {
            if (pTargetType.isFloatingPointType()) {
                Op fpToFp = this.solver.mkOp(Kind.FLOATINGPOINT_TO_FP_FROM_FP, ((FormulaType.FloatingPointType)pTargetType).getExponentSize(), ((FormulaType.FloatingPointType)pTargetType).getMantissaSize() + 1);
                return this.solver.mkTerm(fpToFp, pRoundingMode, pNumber);
            }
            if (pTargetType.isBitvectorType()) {
                FormulaType.BitvectorType targetType = (FormulaType.BitvectorType)pTargetType;
                Kind kind = pSigned ? Kind.FLOATINGPOINT_TO_SBV : Kind.FLOATINGPOINT_TO_UBV;
                Op operation = this.solver.mkOp(kind, targetType.getSize());
                return this.solver.mkTerm(operation, pRoundingMode, pNumber);
            }
            if (pTargetType.isRationalType()) {
                return this.solver.mkTerm(Kind.FLOATINGPOINT_TO_REAL, pNumber);
            }
            return this.genericCast(pNumber, pTargetType);
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("You tried creating a invalid cast from " + pNumber + " into a " + pTargetType + ". Check that the target type can hold the source type. (Note: for target FP types 1 bit is missing in this debug message)", e);
        }
    }

    @Override
    protected Term castFromImpl(Term pNumber, boolean pSigned, FormulaType.FloatingPointType pTargetType, Term pRoundingMode) {
        FormulaType<?> formulaType = this.getFormulaCreator().getFormulaType(pNumber);
        try {
            if (formulaType.isFloatingPointType()) {
                return this.castToImpl(pNumber, pSigned, (FormulaType<?>)pTargetType, pRoundingMode);
            }
            if (formulaType.isRationalType()) {
                Op realToFp = this.solver.mkOp(Kind.FLOATINGPOINT_TO_FP_FROM_REAL, pTargetType.getExponentSize(), pTargetType.getMantissaSize() + 1);
                return this.solver.mkTerm(realToFp, pRoundingMode, pNumber);
            }
            if (formulaType.isBitvectorType()) {
                if (pSigned) {
                    Op realToSBv = this.solver.mkOp(Kind.FLOATINGPOINT_TO_FP_FROM_SBV, pTargetType.getExponentSize(), pTargetType.getMantissaSize() + 1);
                    return this.solver.mkTerm(realToSBv, pRoundingMode, pNumber);
                }
                Op realToUBv = this.solver.mkOp(Kind.FLOATINGPOINT_TO_FP_FROM_UBV, pTargetType.getExponentSize(), pTargetType.getMantissaSize() + 1);
                return this.solver.mkTerm(realToUBv, pRoundingMode, pNumber);
            }
            return this.genericCast(pNumber, pTargetType);
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("You tried creating a invalid cast from " + pNumber + " into a FloatingPoint with exponent size " + pTargetType.getExponentSize() + " and mantissa size " + pTargetType.getMantissaSize() + ".", e);
        }
    }

    private Term genericCast(Term pNumber, FormulaType<?> pTargetType) {
        Sort type = pNumber.getSort();
        FormulaType<?> argType = this.getFormulaCreator().getFormulaType(pNumber);
        Term castFuncDecl = (Term)this.getFormulaCreator().declareUFImpl("__cast_" + argType + "_to_" + pTargetType, (Sort)this.toSolverType(pTargetType), (List<Sort>)ImmutableList.of((Object)type));
        return this.solver.mkTerm(Kind.APPLY_UF, castFuncDecl, pNumber);
    }

    @Override
    protected Term negate(Term pParam1) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_NEG, pParam1);
    }

    @Override
    protected Term abs(Term pParam1) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_ABS, pParam1);
    }

    @Override
    protected Term max(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_MAX, pParam1, pParam2);
    }

    @Override
    protected Term min(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_MIN, pParam1, pParam2);
    }

    @Override
    protected Term sqrt(Term pParam1, Term pRoundingMode) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_SQRT, pRoundingMode, pParam1);
    }

    @Override
    protected Term add(Term pParam1, Term pParam2, Term pRoundingMode) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_ADD, pRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Term subtract(Term pParam1, Term pParam2, Term pRoundingMode) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_SUB, pRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Term divide(Term pParam1, Term pParam2, Term pRoundingMode) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_DIV, pRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Term multiply(Term pParam1, Term pParam2, Term pRoundingMode) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_MULT, pRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Term assignment(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.EQUAL, pParam1, pParam2);
    }

    @Override
    protected Term equalWithFPSemantics(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_EQ, pParam1, pParam2);
    }

    @Override
    protected Term greaterThan(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_GT, pParam1, pParam2);
    }

    @Override
    protected Term greaterOrEquals(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_GEQ, pParam1, pParam2);
    }

    @Override
    protected Term lessThan(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_LT, pParam1, pParam2);
    }

    @Override
    protected Term lessOrEquals(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_LEQ, pParam1, pParam2);
    }

    @Override
    protected Term isNaN(Term pParam1) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_IS_NAN, pParam1);
    }

    @Override
    protected Term isInfinity(Term pParam1) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_IS_INF, pParam1);
    }

    @Override
    protected Term isZero(Term pParam1) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_IS_ZERO, pParam1);
    }

    @Override
    protected Term isSubnormal(Term pParam1) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_IS_SUBNORMAL, pParam1);
    }

    @Override
    protected Term isNormal(Term pParam) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_IS_NORMAL, pParam);
    }

    @Override
    protected Term isNegative(Term pParam) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_IS_NEG, pParam);
    }

    @Override
    protected Term fromIeeeBitvectorImpl(Term pNumber, FormulaType.FloatingPointType pTargetType) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_TO_FP_FROM_IEEE_BV, pNumber);
    }

    @Override
    protected Term toIeeeBitvectorImpl(Term pNumber) {
        throw new UnsupportedOperationException("FP to IEEE-BV is not supported");
    }

    @Override
    protected Term round(Term pFormula, FloatingPointRoundingMode pRoundingMode) {
        return this.solver.mkTerm(Kind.FLOATINGPOINT_RTI, this.getRoundingModeImpl(pRoundingMode), pFormula);
    }
}

