/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Result;
import io.github.cvc5.Solver;
import io.github.cvc5.Term;
import io.github.cvc5.UnknownExplanation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Evaluator;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5Evaluator;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5Model;

public class CVC5AbstractProver<T>
extends AbstractProverWithAllSat<T> {
    private final FormulaManager mgr;
    protected final CVC5FormulaCreator creator;
    protected final Solver solver;
    private boolean changedSinceLastSatQuery = false;
    protected final Deque<List<Term>> assertedFormulas = new ArrayDeque<List<Term>>();
    protected final boolean incremental;

    protected CVC5AbstractProver(CVC5FormulaCreator pFormulaCreator, ShutdownNotifier pShutdownNotifier, int randomSeed, Set<SolverContext.ProverOptions> pOptions, FormulaManager pMgr) {
        super(pOptions, pMgr.getBooleanFormulaManager(), pShutdownNotifier);
        this.mgr = pMgr;
        this.creator = pFormulaCreator;
        this.incremental = !this.enableSL;
        this.assertedFormulas.push(new ArrayList());
        this.solver = new Solver();
        this.setSolverOptions(randomSeed, pOptions);
    }

    private void setSolverOptions(int randomSeed, Set<SolverContext.ProverOptions> pOptions) {
        if (this.incremental) {
            this.solver.setOption("incremental", "true");
        }
        if (pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS)) {
            this.solver.setOption("produce-models", "true");
        }
        if (pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE)) {
            this.solver.setOption("produce-unsat-cores", "true");
        }
        this.solver.setOption("produce-assertions", "true");
        this.solver.setOption("dump-models", "true");
        this.solver.setOption("output-language", "smt2");
        this.solver.setOption("seed", String.valueOf(randomSeed));
        this.solver.setOption("strings-exp", "true");
        this.solver.setOption("full-saturate-quant", "true");
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.setChanged();
        this.assertedFormulas.push(new ArrayList());
        if (this.incremental) {
            try {
                this.solver.push();
            }
            catch (CVC5ApiException e) {
                throw new IllegalStateException("You tried to use push() on an CVC5 assertion stack illegally.", e);
            }
        }
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.setChanged();
        this.assertedFormulas.pop();
        Preconditions.checkState((!this.assertedFormulas.isEmpty() ? 1 : 0) != 0, (Object)"initial level must remain until close");
        if (this.incremental) {
            try {
                this.solver.pop();
            }
            catch (CVC5ApiException e) {
                throw new IllegalStateException("You tried to use pop() on an CVC5 assertion stack illegally.", e);
            }
        }
    }

    @Override
    public @Nullable T addConstraint(BooleanFormula pF) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.setChanged();
        Term exp = this.creator.extractInfo(pF);
        this.assertedFormulas.peek().add(exp);
        if (this.incremental) {
            this.solver.assertFormula(exp);
        }
        return null;
    }

    @Override
    public CVC5Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        this.checkGenerateModels();
        return this.registerEvaluator(new CVC5Model(this, this.mgr, this.creator, this.getAssertedExpressions()));
    }

    @Override
    public Evaluator getEvaluator() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        return this.getEvaluatorWithoutChecks();
    }

    @Override
    protected Evaluator getEvaluatorWithoutChecks() {
        return this.registerEvaluator(new CVC5Evaluator(this, this.creator));
    }

    protected void setChanged() {
        if (!this.changedSinceLastSatQuery) {
            this.changedSinceLastSatQuery = true;
            this.closeAllEvaluators();
        }
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        return super.getModelAssignments();
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closeAllEvaluators();
        this.changedSinceLastSatQuery = false;
        if (!this.incremental) {
            this.getAssertedExpressions().forEach(arg_0 -> ((Solver)this.solver).assertFormula(arg_0));
        }
        Result result = this.solver.checkSat();
        this.shutdownNotifier.shutdownIfNecessary();
        return this.convertSatResult(result);
    }

    private boolean convertSatResult(Result result) throws InterruptedException, SolverException {
        if (result.isUnknown()) {
            if (result.getUnknownExplanation().equals((Object)UnknownExplanation.INTERRUPTED)) {
                throw new InterruptedException();
            }
            throw new SolverException("CVC5 returned null or unknown on sat check. Exact result: " + result + ".");
        }
        return result.isUnsat();
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        ArrayList<BooleanFormula> converted = new ArrayList<BooleanFormula>();
        for (Term aCore : this.solver.getUnsatCore()) {
            converted.add(this.creator.encapsulateBoolean(aCore));
        }
        return converted;
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected Collection<Term> getAssertedExpressions() {
        ArrayList<Term> result = new ArrayList<Term>();
        this.assertedFormulas.forEach(result::addAll);
        return result;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.assertedFormulas.clear();
            this.solver.deletePointer();
            this.closed = true;
        }
        super.close();
    }

    @Override
    public int size() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.assertedFormulas.size() - 1;
    }
}

