/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.Kind;
import edu.stanford.CVC4.Type;
import edu.stanford.CVC4.vectorExpr;
import java.util.Collection;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;

public class CVC4BooleanFormulaManager
extends AbstractBooleanFormulaManager<Expr, Type, ExprManager, Expr> {
    private final Expr cvc4True;
    private final Expr cvc4False;
    private final ExprManager exprManager;

    protected CVC4BooleanFormulaManager(CVC4FormulaCreator pCreator) {
        super(pCreator);
        this.exprManager = (ExprManager)pCreator.getEnv();
        this.cvc4True = this.exprManager.mkConst(true);
        this.cvc4False = this.exprManager.mkConst(false);
    }

    @Override
    protected Expr makeVariableImpl(String pVar) {
        return (Expr)this.formulaCreator.makeVariable((Type)this.getFormulaCreator().getBoolType(), pVar);
    }

    @Override
    protected Expr makeBooleanImpl(boolean pValue) {
        return this.exprManager.mkConst(pValue);
    }

    @Override
    protected Expr not(Expr pParam1) {
        return this.exprManager.mkExpr(Kind.NOT, pParam1);
    }

    @Override
    protected Expr and(Expr pParam1, Expr pParam2) {
        if (this.isTrue(pParam1)) {
            return pParam2;
        }
        if (this.isTrue(pParam2)) {
            return pParam1;
        }
        if (this.isFalse(pParam1)) {
            return this.cvc4False;
        }
        if (this.isFalse(pParam2)) {
            return this.cvc4False;
        }
        if (pParam1 == pParam2) {
            return pParam1;
        }
        return this.exprManager.mkExpr(Kind.AND, pParam1, pParam2);
    }

    @Override
    protected Expr andImpl(Collection<Expr> pParams) {
        vectorExpr vExpr = new vectorExpr();
        for (Expr e : pParams) {
            if (this.isFalse(e)) {
                return this.cvc4False;
            }
            if (this.isTrue(e)) continue;
            vExpr.add(e);
        }
        if (vExpr.capacity() == 0L) {
            return this.cvc4True;
        }
        if (vExpr.capacity() == 1L) {
            return vExpr.get(0);
        }
        return this.exprManager.mkExpr(Kind.AND, vExpr);
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toConjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), this::and);
    }

    @Override
    protected Expr or(Expr pParam1, Expr pParam2) {
        if (this.isTrue(pParam1)) {
            return this.cvc4True;
        }
        if (this.isTrue(pParam2)) {
            return this.cvc4True;
        }
        if (this.isFalse(pParam1)) {
            return pParam2;
        }
        if (this.isFalse(pParam2)) {
            return pParam1;
        }
        if (pParam1 == pParam2) {
            return pParam1;
        }
        return this.exprManager.mkExpr(Kind.OR, pParam1, pParam2);
    }

    @Override
    protected Expr orImpl(Collection<Expr> pParams) {
        vectorExpr vExpr = new vectorExpr();
        for (Expr e : pParams) {
            if (this.isTrue(e)) {
                return this.cvc4True;
            }
            if (this.isFalse(e)) continue;
            vExpr.add(e);
        }
        if (vExpr.capacity() == 0L) {
            return this.cvc4False;
        }
        if (vExpr.capacity() == 1L) {
            return vExpr.get(0);
        }
        return this.exprManager.mkExpr(Kind.OR, vExpr);
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toDisjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), this::or);
    }

    @Override
    protected Expr xor(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.XOR, pParam1, pParam2);
    }

    @Override
    protected Expr equivalence(Expr pBits1, Expr pBits2) {
        return this.exprManager.mkExpr(Kind.EQUAL, pBits1, pBits2);
    }

    @Override
    protected Expr implication(Expr bits1, Expr bits2) {
        return this.exprManager.mkExpr(Kind.IMPLIES, bits1, bits2);
    }

    @Override
    protected boolean isTrue(Expr pBits) {
        return pBits.isConst() && pBits.getConstBoolean();
    }

    @Override
    protected boolean isFalse(Expr pBits) {
        return pBits.isConst() && !pBits.getConstBoolean();
    }

    @Override
    protected Expr ifThenElse(Expr pCond, Expr pF1, Expr pF2) {
        return this.exprManager.mkExpr(Kind.ITE, pCond, pF1, pF2);
    }
}

