/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.synchronize;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedModelWithContext;

class SynchronizedBasicProverEnvironmentWithContext<T>
implements BasicProverEnvironment<T> {
    private final BasicProverEnvironment<T> delegate;
    final FormulaManager manager;
    final FormulaManager otherManager;
    final SolverContext sync;

    SynchronizedBasicProverEnvironmentWithContext(BasicProverEnvironment<T> pDelegate, SolverContext pSync, FormulaManager pManager, FormulaManager pOtherManager) {
        this.delegate = (BasicProverEnvironment)Preconditions.checkNotNull(pDelegate);
        this.sync = (SolverContext)Preconditions.checkNotNull((Object)pSync);
        this.manager = (FormulaManager)Preconditions.checkNotNull((Object)pManager);
        this.otherManager = (FormulaManager)Preconditions.checkNotNull((Object)pOtherManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BooleanFormula> translate(Collection<BooleanFormula> fs, FormulaManager from, FormulaManager to) {
        ImmutableList.Builder result = ImmutableList.builder();
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            for (BooleanFormula f : fs) {
                result.add((Object)to.translateFrom(f, from));
            }
        }
        return result.build();
    }

    @Override
    public void pop() {
        this.delegate.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable T addConstraint(BooleanFormula pConstraint) throws InterruptedException {
        BooleanFormula constraint;
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            constraint = this.otherManager.translateFrom(pConstraint, this.manager);
        }
        return this.delegate.addConstraint(constraint);
    }

    @Override
    public void push() throws InterruptedException {
        this.delegate.push();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.size();
        }
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        return this.delegate.isUnsat();
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        return this.delegate.isUnsatWithAssumptions(this.translate(pAssumptions, this.manager, this.otherManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getModel() throws SolverException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedModelWithContext(this.delegate.getModel(), this.sync, this.manager, this.otherManager);
        }
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        return this.translate(this.delegate.getUnsatCore(), this.otherManager, this.manager);
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        Optional<List<BooleanFormula>> core = this.delegate.unsatCoreOverAssumptions(this.translate(pAssumptions, this.manager, this.otherManager));
        if (core.isPresent()) {
            return Optional.of(this.translate((Collection<BooleanFormula>)core.orElseThrow(), this.otherManager, this.manager));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMap<String, String> getStatistics() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.getStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            this.delegate.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> pCallback, List<BooleanFormula> pImportant) throws InterruptedException, SolverException {
        AllSatCallbackWithContext<R> callback = new AllSatCallbackWithContext<R>(pCallback);
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.allSat(callback, this.translate(pImportant, this.manager, this.otherManager));
        }
    }

    private class AllSatCallbackWithContext<R>
    implements BasicProverEnvironment.AllSatCallback<R> {
        private final BasicProverEnvironment.AllSatCallback<R> delegateCallback;

        AllSatCallbackWithContext(BasicProverEnvironment.AllSatCallback<R> pDelegateCallback) {
            this.delegateCallback = (BasicProverEnvironment.AllSatCallback)Preconditions.checkNotNull(pDelegateCallback);
        }

        @Override
        public void apply(List<BooleanFormula> pModel) {
            this.delegateCallback.apply(SynchronizedBasicProverEnvironmentWithContext.this.translate(pModel, SynchronizedBasicProverEnvironmentWithContext.this.otherManager, SynchronizedBasicProverEnvironmentWithContext.this.manager));
        }

        @Override
        public R getResult() throws InterruptedException {
            return this.delegateCallback.getResult();
        }
    }
}

