/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.synchronize;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedModel;

class SynchronizedBasicProverEnvironment<T>
implements BasicProverEnvironment<T> {
    private final BasicProverEnvironment<T> delegate;
    final SolverContext sync;

    SynchronizedBasicProverEnvironment(BasicProverEnvironment<T> pDelegate, SolverContext pSync) {
        this.delegate = (BasicProverEnvironment)Preconditions.checkNotNull(pDelegate);
        this.sync = (SolverContext)Preconditions.checkNotNull((Object)pSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pop() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            this.delegate.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable T addConstraint(BooleanFormula pConstraint) throws InterruptedException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.addConstraint(pConstraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push() throws InterruptedException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            this.delegate.push();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.isUnsat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.isUnsatWithAssumptions(pAssumptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getModel() throws SolverException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedModel(this.delegate.getModel(), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BooleanFormula> getUnsatCore() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.getUnsatCore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.unsatCoreOverAssumptions(pAssumptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableMap<String, String> getStatistics() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.getStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            this.delegate.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> pCallback, List<BooleanFormula> pImportant) throws InterruptedException, SolverException {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.allSat(pCallback, pImportant);
        }
    }
}

