/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.logging;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;

class LoggingBasicProverEnvironment<T>
implements BasicProverEnvironment<T> {
    private final BasicProverEnvironment<T> wrapped;
    final LogManager logger;
    private int level = 0;

    LoggingBasicProverEnvironment(BasicProverEnvironment<T> pWrapped, LogManager pLogger) {
        this.wrapped = (BasicProverEnvironment)Preconditions.checkNotNull(pWrapped);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
    }

    @Override
    public T push(BooleanFormula f) throws InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"up to level " + this.level++});
        this.logger.log(Level.FINE, new Object[]{"formula pushed:", f});
        return this.wrapped.push(f);
    }

    @Override
    public void pop() {
        this.logger.log(Level.FINER, new Object[]{"down to level " + this.level--});
        this.wrapped.pop();
    }

    @Override
    public T addConstraint(BooleanFormula constraint) throws InterruptedException {
        return this.wrapped.addConstraint(constraint);
    }

    @Override
    public void push() throws InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"up to level " + this.level++});
        this.wrapped.push();
    }

    @Override
    public int size() {
        int result = this.wrapped.size();
        Preconditions.checkState((result == this.level ? 1 : 0) != 0);
        this.logger.log(Level.FINE, new Object[]{"number of levels " + result});
        return result;
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        boolean result = this.wrapped.isUnsat();
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"assumptions:", pAssumptions});
        boolean result = this.wrapped.isUnsatWithAssumptions(pAssumptions);
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public Model getModel() throws SolverException {
        Model m = this.wrapped.getModel();
        this.logger.log(Level.FINE, new Object[]{"model", m});
        return m;
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        ImmutableList<Model.ValueAssignment> m = this.wrapped.getModelAssignments();
        this.logger.log(Level.FINE, new Object[]{"model", m});
        return m;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        List<BooleanFormula> unsatCore = this.wrapped.getUnsatCore();
        this.logger.log(Level.FINE, new Object[]{"unsat-core", unsatCore});
        return unsatCore;
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        Optional<List<BooleanFormula>> result = this.wrapped.unsatCoreOverAssumptions(assumptions);
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result.isEmpty()});
        return result;
    }

    @Override
    public ImmutableMap<String, String> getStatistics() {
        return this.wrapped.getStatistics();
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.logger.log(Level.FINER, new Object[]{"closed"});
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        R result = this.wrapped.allSat(callback, important);
        this.logger.log(Level.FINE, new Object[]{"allsat-result:", result});
        return result;
    }
}

