/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.microsoft.z3.Native;
import com.microsoft.z3.enumerations.Z3_ast_print_mode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.solvers.z3.Z3ArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3BitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3IntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3OptimizationProver;
import org.sosy_lab.java_smt.solvers.z3.Z3QuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3RationalFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3TheoremProver;
import org.sosy_lab.java_smt.solvers.z3.Z3UFManager;

@Options(prefix="solver.z3")
final class Z3SolverContext
extends AbstractSolverContext {
    @Option(secure=true, description="Engine to use for the optimization", values={"basic", "farkas", "symba"})
    String optimizationEngine = "basic";
    @Option(secure=true, description="Ordering for objectives in the optimization context", values={"lex", "pareto", "box"})
    String objectivePrioritizationMode = "box";
    private final ShutdownNotifier.ShutdownRequestListener interruptListener;
    private final @Nullable PathCounterTemplate logfile;
    private final long z3params;
    private final LogManager logger;
    private final Z3FormulaCreator creator;
    private final Z3FormulaManager manager;
    private boolean closed = false;
    private static final String OPT_ENGINE_CONFIG_KEY = "optsmt_engine";
    private static final String OPT_PRIORITY_CONFIG_KEY = "priority";

    private Z3SolverContext(Z3FormulaCreator pFormulaCreator, Configuration config, long pZ3params, ShutdownNotifier.ShutdownRequestListener pInterruptListener, ShutdownNotifier pShutdownNotifier, LogManager pLogger, Z3FormulaManager pManager, PathCounterTemplate pSolverLogFile) throws InvalidConfigurationException {
        super(pManager);
        this.creator = pFormulaCreator;
        config.inject((Object)this);
        this.z3params = pZ3params;
        this.interruptListener = pInterruptListener;
        pShutdownNotifier.register(this.interruptListener);
        this.logger = pLogger;
        this.manager = pManager;
        this.logfile = pSolverLogFile;
    }

    public static synchronized Z3SolverContext create(LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogfile, long randomSeed, FloatingPointRoundingMode pFloatingPointRoundingMode, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) throws InvalidConfigurationException {
        ExtraOptions extraOptions = new ExtraOptions();
        config.inject((Object)extraOptions);
        try {
            System.loadLibrary("z3");
            System.loadLibrary("z3java");
        }
        catch (UnsatisfiedLinkError e1) {
            try {
                System.loadLibrary("libz3");
                System.loadLibrary("libz3java");
            }
            catch (UnsatisfiedLinkError e2) {
                e1.addSuppressed(e2);
                throw e1;
            }
        }
        if (extraOptions.log != null) {
            Path absolutePath = extraOptions.log.toAbsolutePath();
            try {
                IO.writeFile((Path)absolutePath, (Charset)StandardCharsets.US_ASCII, (Object)"");
                Native.openLog((String)absolutePath.toString());
            }
            catch (IOException e) {
                logger.logUserException(Level.WARNING, (Throwable)e, "Cannot write Z3 log file");
            }
        }
        long cfg = Native.mkConfig();
        if (extraOptions.requireProofs) {
            Native.setParamValue((long)cfg, (String)"PROOF", (String)"true");
        }
        Native.globalParamSet((String)"smt.random_seed", (String)String.valueOf(randomSeed));
        Native.globalParamSet((String)"model.compact", (String)"false");
        long context = Native.mkContextRc((long)cfg);
        ShutdownNotifier.ShutdownRequestListener interruptListener = reason -> Native.interrupt((long)context);
        Native.delConfig((long)cfg);
        long boolSort = Native.mkBoolSort((long)context);
        Native.incRef((long)context, (long)Native.sortToAst((long)context, (long)boolSort));
        long integerSort = Native.mkIntSort((long)context);
        Native.incRef((long)context, (long)Native.sortToAst((long)context, (long)integerSort));
        long realSort = Native.mkRealSort((long)context);
        Native.incRef((long)context, (long)Native.sortToAst((long)context, (long)realSort));
        Native.setAstPrintMode((long)context, (int)Z3_ast_print_mode.Z3_PRINT_SMTLIB2_COMPLIANT.toInt());
        long z3params = Native.mkParams((long)context);
        Native.paramsIncRef((long)context, (long)z3params);
        Native.paramsSetUint((long)context, (long)z3params, (long)Native.mkStringSymbol((long)context, (String)":random-seed"), (int)((int)randomSeed));
        Z3FormulaCreator creator = new Z3FormulaCreator(context, boolSort, integerSort, realSort, config, pShutdownNotifier);
        Z3UFManager functionTheory = new Z3UFManager(creator);
        Z3BooleanFormulaManager booleanTheory = new Z3BooleanFormulaManager(creator);
        Z3IntegerFormulaManager integerTheory = new Z3IntegerFormulaManager(creator, pNonLinearArithmetic);
        Z3RationalFormulaManager rationalTheory = new Z3RationalFormulaManager(creator, pNonLinearArithmetic);
        Z3BitvectorFormulaManager bitvectorTheory = new Z3BitvectorFormulaManager(creator);
        Z3FloatingPointFormulaManager floatingPointTheory = new Z3FloatingPointFormulaManager(creator, pFloatingPointRoundingMode);
        Z3QuantifiedFormulaManager quantifierManager = new Z3QuantifiedFormulaManager(creator);
        Z3ArrayFormulaManager arrayManager = new Z3ArrayFormulaManager(creator);
        Native.setInternalErrorHandler((long)context);
        Z3FormulaManager manager = new Z3FormulaManager(creator, functionTheory, booleanTheory, integerTheory, rationalTheory, bitvectorTheory, floatingPointTheory, quantifierManager, arrayManager);
        return new Z3SolverContext(creator, config, z3params, interruptListener, pShutdownNotifier, logger, manager, solverLogfile);
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"solver context is already closed");
        long z3context = (Long)this.creator.getEnv();
        Native.paramsSetBool((long)z3context, (long)this.z3params, (long)Native.mkStringSymbol((long)z3context, (String)":model"), (options.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS) || options.contains((Object)SolverContext.ProverOptions.GENERATE_ALL_SAT) ? 1 : 0) != 0);
        Native.paramsSetBool((long)z3context, (long)this.z3params, (long)Native.mkStringSymbol((long)z3context, (String)":unsat_core"), (options.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE) || options.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS) ? 1 : 0) != 0);
        return new Z3TheoremProver(this.creator, this.manager, this.z3params, options, this.logfile);
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> options) {
        throw new UnsupportedOperationException("Z3 does not support interpolation");
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"solver context is already closed");
        Z3OptimizationProver out = new Z3OptimizationProver(this.creator, this.logger, this.z3params, this.manager, options, this.logfile);
        out.setParam(OPT_ENGINE_CONFIG_KEY, this.optimizationEngine);
        out.setParam(OPT_PRIORITY_CONFIG_KEY, this.objectivePrioritizationMode);
        return out;
    }

    @Override
    public String getVersion() {
        Native.IntPtr major = new Native.IntPtr();
        Native.IntPtr minor = new Native.IntPtr();
        Native.IntPtr build = new Native.IntPtr();
        Native.IntPtr revision = new Native.IntPtr();
        Native.getVersion((Native.IntPtr)major, (Native.IntPtr)minor, (Native.IntPtr)build, (Native.IntPtr)revision);
        return "Z3 " + major.value + "." + minor.value + "." + build.value + "." + revision.value;
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.Z3;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            long context = (Long)this.creator.getEnv();
            this.creator.forceClose();
            Native.paramsDecRef((long)context, (long)this.z3params);
            Native.closeLog();
            Native.delContext((long)context);
        }
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return true;
    }

    @Options(prefix="solver.z3")
    private static class ExtraOptions {
        @Option(secure=true, description="Require proofs from SMT solver")
        boolean requireProofs = false;
        @Option(secure=true, description="Activate replayable logging in Z3. The log can be given as an input to the solver and replayed.")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        @Nullable Path log = null;

        private ExtraOptions() {
        }
    }
}

