/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolEnvironment;

class SmtInterpolModel
extends AbstractModel.CachingAbstractModel<Term, Sort, SmtInterpolEnvironment> {
    private final Model model;

    SmtInterpolModel(Model pModel, FormulaCreator<Term, Sort, SmtInterpolEnvironment, ?> pCreator) {
        super(pCreator);
        this.model = pModel;
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> toList() {
        ImmutableSet.Builder assignments = ImmutableSet.builder();
        for (FunctionSymbol symbol : this.model.getDefinedFunctions()) {
            String name = SmtInterpolModel.unescape(symbol.getApplicationString());
            if (symbol.getParameterSorts().length == 0) {
                Term variable = ((SmtInterpolEnvironment)this.creator.getEnv()).term(name, new Term[0]);
                if (symbol.getReturnSort().isArraySort()) {
                    assignments.addAll(this.getArrayAssignment(name, variable, variable, (List<Object>)ImmutableList.of()));
                    continue;
                }
                assignments.add((Object)this.getAssignment(name, (ApplicationTerm)variable));
                continue;
            }
            assignments.addAll(this.getUFAssignments(symbol));
        }
        return assignments.build().asList();
    }

    private static String unescape(String s) {
        return s.startsWith("|") ? s.substring(1, s.length() - 1) : s;
    }

    private Collection<Model.ValueAssignment> getArrayAssignment(String symbol, Term key, Term array, List<Object> upperIndices) {
        assert (array.getSort().isArraySort());
        ArrayList<Model.ValueAssignment> assignments = new ArrayList<Model.ValueAssignment>();
        Term evaluation = this.model.evaluate(array);
        while (evaluation instanceof ApplicationTerm) {
            ApplicationTerm arrayEval = (ApplicationTerm)evaluation;
            FunctionSymbol funcDecl = arrayEval.getFunction();
            Term[] params = arrayEval.getParameters();
            if (!funcDecl.isIntern() || !"store".equals(funcDecl.getName())) break;
            Term index = params[1];
            Term content = params[2];
            ArrayList<Object> innerIndices = new ArrayList<Object>(upperIndices);
            innerIndices.add(this.evaluateImpl(index));
            Term select = ((SmtInterpolEnvironment)this.creator.getEnv()).term("select", key, index);
            if (content.getSort().isArraySort()) {
                assignments.addAll(this.getArrayAssignment(symbol, select, content, innerIndices));
            } else {
                assignments.add(new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(select), this.creator.encapsulateWithTypeOf(this.model.evaluate(content)), this.creator.encapsulateBoolean(((SmtInterpolEnvironment)this.creator.getEnv()).term("=", select, content)), symbol, this.evaluateImpl(content), innerIndices));
            }
            evaluation = params[0];
        }
        return assignments;
    }

    private Collection<Model.ValueAssignment> getUFAssignments(FunctionSymbol symbol) {
        ArrayList<Model.ValueAssignment> assignments = new ArrayList<Model.ValueAssignment>();
        String name = SmtInterpolModel.unescape(symbol.getApplicationString());
        de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model mmodel = (de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model)this.model;
        for (FunctionValue.Index key : mmodel.getFunctionValue(symbol).values().keySet()) {
            assignments.add(this.getAssignment(name, (ApplicationTerm)((SmtInterpolEnvironment)this.creator.getEnv()).term(name, key.toArray())));
        }
        return assignments;
    }

    private Model.ValueAssignment getAssignment(String key, ApplicationTerm term) {
        Term value = this.model.evaluate((Term)term);
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (Term param : term.getParameters()) {
            argumentInterpretation.add(this.evaluateImpl(param));
        }
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(term), this.creator.encapsulateWithTypeOf(value), this.creator.encapsulateBoolean(((SmtInterpolEnvironment)this.creator.getEnv()).term("=", new Term[]{term, value})), key, this.evaluateImpl(term), argumentInterpretation);
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    @Override
    public void close() {
    }

    @Override
    protected Term evalImpl(Term formula) {
        return this.model.evaluate(formula);
    }
}

