/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ParseEnvironment;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.smtinterpol.FormulaCollectionScript;
import org.sosy_lab.java_smt.solvers.smtinterpol.LogProxyForwarder;
import org.sosy_lab.java_smt.solvers.smtinterpol.LoggingSmtInterpolInterpolatingProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolInterpolatingProver;

@Options(prefix="solver.smtinterpol")
public class SmtInterpolEnvironment {
    private static final ImmutableSet<String> UNSUPPORTED_IDENTIFIERS = ImmutableSet.of((Object)"true", (Object)"false", (Object)"select", (Object)"store", (Object)"or", (Object)"and", (Object[])new String[]{"xor", "distinct"});
    @Option(secure=true, description="Double check generated results like interpolants and models whether they are correct")
    private boolean checkResults = false;
    private final @Nullable PathCounterTemplate smtLogfile;
    @Option(secure=true, description="Further options that will be set to true for SMTInterpol in addition to the default options. Format is 'option1,option2,option3'")
    private List<String> furtherOptions = ImmutableList.of();
    private final LogManager logger;
    private final LogProxy smtInterpolLogProxy;
    private final ShutdownNotifier shutdownNotifier;
    private final Script script;
    private final Theory theory;
    private int stackDepth = 0;

    SmtInterpolEnvironment(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate pSmtLogfile, long randomSeed) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.smtLogfile = pSmtLogfile;
        this.smtInterpolLogProxy = new LogProxyForwarder(this.logger.withComponentName("SMTInterpol"));
        SMTInterpol smtInterpol = new SMTInterpol(this.smtInterpolLogProxy, () -> ((ShutdownNotifier)pShutdownNotifier).shouldShutdown());
        this.script = this.smtLogfile != null ? this.createLoggingWrapper(smtInterpol) : smtInterpol;
        this.script.setOption(":global-declarations", (Object)true);
        this.script.setOption(":random-seed", (Object)randomSeed);
        this.script.setOption(":produce-interpolants", (Object)true);
        this.script.setOption(":produce-models", (Object)true);
        this.script.setOption(":produce-unsat-cores", (Object)true);
        if (this.checkResults) {
            this.script.setOption(":interpolant-check-mode", (Object)true);
            this.script.setOption(":unsat-core-check-mode", (Object)true);
            this.script.setOption(":model-check-mode", (Object)true);
        }
        this.script.setLogic(Logics.ALL);
        for (String option : this.furtherOptions) {
            try {
                this.script.setOption(":" + option, (Object)true);
            }
            catch (SMTLIBException | UnsupportedOperationException e) {
                throw new InvalidConfigurationException("Invalid option \"" + option + "\" for SMTInterpol.", e);
            }
        }
        this.theory = smtInterpol.getTheory();
    }

    private Script createLoggingWrapper(SMTInterpol smtInterpol) {
        assert (this.smtLogfile != null);
        String filename = this.smtLogfile.getFreshPath().toAbsolutePath().toString();
        try {
            return new LoggingScript((Script)smtInterpol, filename, true, true);
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not open log file for SMTInterpol queries");
            return smtInterpol;
        }
    }

    Theory getTheory() {
        return this.theory;
    }

    SmtInterpolInterpolatingProver getInterpolator(SmtInterpolFormulaManager mgr, Set<SolverContext.ProverOptions> pOptions) {
        if (this.smtLogfile != null) {
            Path logfile = this.smtLogfile.getFreshPath();
            try {
                PrintWriter out = new PrintWriter(IO.openOutputFile((Path)logfile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]));
                out.println("(set-option :global-declarations true)");
                out.println("(set-option :random-seed " + this.script.getOption(":random-seed") + ")");
                out.println("(set-option :produce-interpolants true)");
                out.println(String.format("(set-option :produce-models %s)", pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS)));
                out.println(String.format("(set-option :produce-unsat-cores %s)", pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE)));
                if (this.checkResults) {
                    out.println("(set-option :interpolant-check-mode true)");
                    out.println("(set-option :unsat-core-check-mode true)");
                    out.println("(set-option :model-check-mode true)");
                }
                out.println("(set-logic " + this.theory.getLogic().name() + ")");
                return new LoggingSmtInterpolInterpolatingProver(mgr, pOptions, out);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write interpolation query to file");
            }
        }
        return new SmtInterpolInterpolatingProver(mgr, pOptions);
    }

    int getStackDepth() {
        return this.stackDepth;
    }

    public List<Term> parseStringToTerms(String s) {
        FormulaCollectionScript parseScript = new FormulaCollectionScript(this.script, this.theory);
        ParseEnvironment parseEnv = new ParseEnvironment(parseScript, new OptionMap(this.smtInterpolLogProxy, true)){

            public void printError(String pMessage) {
                throw new SMTLIBException(pMessage);
            }

            public void printSuccess() {
            }
        };
        try {
            parseEnv.parseStream((Reader)new StringReader(s), "<stdin>");
        }
        catch (SMTLIBException nested) {
            throw new IllegalArgumentException(nested);
        }
        return parseScript.getAssertedTerms();
    }

    public void setOption(String opt, Object value) {
        this.script.setOption(opt, value);
    }

    @CanIgnoreReturnValue
    public FunctionSymbol declareFun(String fun, Sort[] paramSorts, Sort resultSort) {
        this.checkSymbol(fun);
        FunctionSymbol fsym = this.theory.getFunction(fun, paramSorts);
        if (fsym == null) {
            this.script.declareFun(fun, paramSorts, resultSort);
            return this.theory.getFunction(fun, paramSorts);
        }
        if (!fsym.getReturnSort().equals(resultSort)) {
            throw new IllegalArgumentException("Function " + fun + " is already declared with different definition");
        }
        if (fun.equals("true") || fun.equals("false")) {
            throw new IllegalArgumentException("Cannot declare a variable named " + fun);
        }
        return fsym;
    }

    public void push(int levels) {
        Preconditions.checkArgument((levels > 0 ? 1 : 0) != 0);
        this.script.push(levels);
        this.stackDepth += levels;
    }

    public void pop(int levels) {
        Preconditions.checkArgument((levels >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.stackDepth >= levels ? 1 : 0) != 0, (Object)"not enough levels to remove");
        this.script.pop(levels);
        this.stackDepth -= levels;
    }

    public void assertTerm(Term term) {
        Preconditions.checkState((this.stackDepth > 0 ? 1 : 0) != 0, (Object)"assertions should be on higher levels, because we might need to remove the term again and we have a shared environment for all provers.");
        this.script.assertTerm(term);
    }

    public boolean checkSat() throws InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        Script.LBool result = this.script.checkSat();
        switch (result) {
            case SAT: {
                return true;
            }
            case UNSAT: {
                return false;
            }
            case UNKNOWN: {
                Object reason = this.script.getInfo(":reason-unknown");
                if (!(reason instanceof ReasonUnknown)) {
                    throw new SMTLIBException("checkSat returned UNKNOWN with unknown reason " + reason);
                }
                switch ((ReasonUnknown)reason) {
                    case MEMOUT: {
                        throw new OutOfMemoryError("Out of memory during SMTInterpol operation");
                    }
                    case CANCELLED: {
                        this.shutdownNotifier.shutdownIfNecessary();
                        throw new SMTLIBException("checkSat returned UNKNOWN with unexpected reason " + reason);
                    }
                }
                throw new SMTLIBException("checkSat returned UNKNOWN with unexpected reason " + reason);
            }
        }
        throw new SMTLIBException("checkSat returned " + result);
    }

    public Iterable<Term[]> checkAllSat(Term[] importantPredicates) throws InterruptedException {
        this.shutdownNotifier.shutdownIfNecessary();
        return this.script.checkAllsat(importantPredicates);
    }

    public Model getModel() {
        try {
            return this.script.getModel();
        }
        catch (SMTLIBException e) {
            if (e.getMessage().contains("Context is inconsistent")) {
                throw new IllegalStateException("Model computation failed. Are the pushed formulae satisfiable?", e);
            }
            throw e;
        }
    }

    public Object getInfo(String info) {
        return this.script.getInfo(info);
    }

    public Sort getBooleanSort() {
        return this.theory.getBooleanSort();
    }

    public Sort getIntegerSort() {
        return this.theory.getNumericSort();
    }

    public Sort getRealSort() {
        return this.theory.getRealSort();
    }

    Sort sort(String sortname, Sort ... params) {
        return this.script.sort(sortname, params);
    }

    public Term term(String funcname, Term ... params) {
        return this.script.term(funcname, params);
    }

    public Term term(String funcname, String[] indices, @Nullable Sort returnSort, Term ... params) {
        return this.script.term(funcname, indices, returnSort, params);
    }

    public TermVariable variable(String varname, Sort sort) {
        this.checkSymbol(varname);
        return this.script.variable(varname, sort);
    }

    public Term quantifier(int quantor, TermVariable[] vars, Term body, Term[] ... patterns) {
        return this.script.quantifier(quantor, vars, body, patterns);
    }

    public Term let(TermVariable[] pVars, Term[] pValues, Term pBody) {
        return this.script.let(pVars, pValues, pBody);
    }

    public Term annotate(Term t, Annotation ... annotations) {
        return this.script.annotate(t, annotations);
    }

    public Term numeral(BigInteger num) {
        return this.script.numeral(num);
    }

    public Term numeral(String num) {
        return this.script.numeral(num);
    }

    public Term decimal(String num) {
        return this.script.decimal(num);
    }

    public Term decimal(BigDecimal num) {
        return this.script.decimal(num);
    }

    public Term hexadecimal(String hex) {
        return this.script.hexadecimal(hex);
    }

    public Term binary(String bin) {
        return this.script.binary(bin);
    }

    public Term[] getTreeInterpolants(Term[] partition, int[] startOfSubTree) throws SolverException, InterruptedException {
        Preconditions.checkState((this.stackDepth > 0 ? 1 : 0) != 0, (Object)"interpolants should be on higher levels");
        try {
            return this.script.getInterpolants(partition, startOfSubTree);
        }
        catch (UnsupportedOperationException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Cannot interpolate ")) {
                throw new SolverException(e.getMessage(), e);
            }
            throw e;
        }
        catch (SMTLIBException e) {
            if ("Timeout exceeded".equals(e.getMessage())) {
                this.shutdownNotifier.shutdownIfNecessary();
            }
            throw new AssertionError((Object)e);
        }
    }

    public Term[] getUnsatCore() {
        Preconditions.checkState((this.stackDepth > 0 ? 1 : 0) != 0, (Object)"unsat core should be on higher levels");
        return this.script.getUnsatCore();
    }

    public Term simplify(Term input) {
        SimplifyDDA s = new SimplifyDDA(this.script, true);
        return s.getSimplifiedTerm(input);
    }

    public String getVersion() {
        QuotedObject program = (QuotedObject)this.script.getInfo(":name");
        QuotedObject version = (QuotedObject)this.script.getInfo(":version");
        return program.getValue() + " " + version.getValue();
    }

    private void checkSymbol(String symbol) throws SMTLIBException {
        Preconditions.checkArgument((symbol.indexOf(124) == -1 && symbol.indexOf(92) == -1 ? 1 : 0) != 0, (Object)"Symbol must not contain | or \\");
        Preconditions.checkArgument((!UNSUPPORTED_IDENTIFIERS.contains((Object)symbol) ? 1 : 0) != 0, (String)"SMTInterpol does not support %s as identifier.", (Object)symbol);
    }
}

